/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.component.rest.DummyRestProcessorFactory;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestsDefinition;

public class LoadRestFromXmlTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        jndi.bind("dummy-rest-api", (Object)new DummyRestProcessorFactory());
        return jndi;
    }

    public void testLoadRestFromXml() throws Exception {
        LoadRestFromXmlTest.assertNotNull((String)"Existing foo route should be there", (Object)this.context.getRoute("foo"));
        LoadRestFromXmlTest.assertEquals((int)2, (int)this.context.getRoutes().size());
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:foo", (Object)"Hello World");
        foo.assertIsSatisfied();
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("barRest.xml");
        RestsDefinition rests = this.context.loadRestsDefinition(is);
        this.context.addRestDefinitions((Collection)rests.getRests());
        for (RestDefinition restDefinition : rests.getRests()) {
            List routeDefinitions = restDefinition.asRouteDefinition((CamelContext)this.context);
            this.context.addRouteDefinitions((Collection)routeDefinitions);
        }
        LoadRestFromXmlTest.assertNotNull((String)"Loaded rest route should be there", (Object)this.context.getRoute("route1"));
        LoadRestFromXmlTest.assertEquals((int)3, (int)this.context.getRoutes().size());
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("seda:get-say-hello-bar", (Object)"Bye World");
        bar.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.restConfiguration().host("localhost").component("dummy-rest").apiContextPath("/api-docs");
                this.from("direct:foo").routeId("foo").to("mock:foo");
            }
        };
    }
}

