/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import org.apache.camel.TestSupport;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.OtherwiseDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.WhenDefinition;

public class ChoiceDefinitionTest
extends TestSupport {
    public void testChoiceOutputOrder() throws Exception {
        ChoiceDefinition choice = new ChoiceDefinition();
        WhenDefinition when1 = new WhenDefinition(ChoiceDefinitionTest.body().contains((Object)"Camel"));
        WhenDefinition when2 = new WhenDefinition(ChoiceDefinitionTest.body().contains((Object)"Donkey"));
        OtherwiseDefinition other = new OtherwiseDefinition();
        choice.addOutput((ProcessorDefinition)when1);
        choice.addOutput((ProcessorDefinition)when2);
        choice.addOutput((ProcessorDefinition)other);
        ChoiceDefinitionTest.assertEquals((int)3, (int)choice.getOutputs().size());
        ChoiceDefinitionTest.assertEquals((Object)when1, choice.getOutputs().get(0));
        ChoiceDefinitionTest.assertEquals((Object)when2, choice.getOutputs().get(1));
        ChoiceDefinitionTest.assertEquals((Object)other, choice.getOutputs().get(2));
    }

    public void testChoiceOutputOrderIterate() throws Exception {
        ChoiceDefinition choice = new ChoiceDefinition();
        WhenDefinition when1 = new WhenDefinition(ChoiceDefinitionTest.body().contains((Object)"Camel"));
        WhenDefinition when2 = new WhenDefinition(ChoiceDefinitionTest.body().contains((Object)"Donkey"));
        OtherwiseDefinition other = new OtherwiseDefinition();
        choice.addOutput((ProcessorDefinition)when1);
        choice.addOutput((ProcessorDefinition)when2);
        choice.addOutput((ProcessorDefinition)other);
        ChoiceDefinitionTest.assertEquals((int)3, (int)choice.getOutputs().size());
        int i = 0;
        for (ProcessorDefinition def : choice.getOutputs()) {
            if (i == 0) {
                ChoiceDefinitionTest.assertEquals((Object)when1, (Object)def);
            } else if (i == 1) {
                ChoiceDefinitionTest.assertEquals((Object)when2, (Object)def);
            } else {
                ChoiceDefinitionTest.assertEquals((Object)other, (Object)def);
            }
            ++i;
        }
    }

    public void testChoiceOutputOrderNoOtherwise() throws Exception {
        ChoiceDefinition choice = new ChoiceDefinition();
        WhenDefinition when1 = new WhenDefinition(ChoiceDefinitionTest.body().contains((Object)"Camel"));
        WhenDefinition when2 = new WhenDefinition(ChoiceDefinitionTest.body().contains((Object)"Donkey"));
        choice.addOutput((ProcessorDefinition)when1);
        choice.addOutput((ProcessorDefinition)when2);
        ChoiceDefinitionTest.assertEquals((int)2, (int)choice.getOutputs().size());
        ChoiceDefinitionTest.assertEquals((Object)when1, choice.getOutputs().get(0));
        ChoiceDefinitionTest.assertEquals((Object)when2, choice.getOutputs().get(1));
    }

    public void testChoiceOutputOrderNoOtherwiseIterate() throws Exception {
        ChoiceDefinition choice = new ChoiceDefinition();
        WhenDefinition when1 = new WhenDefinition(ChoiceDefinitionTest.body().contains((Object)"Camel"));
        WhenDefinition when2 = new WhenDefinition(ChoiceDefinitionTest.body().contains((Object)"Donkey"));
        choice.addOutput((ProcessorDefinition)when1);
        choice.addOutput((ProcessorDefinition)when2);
        ChoiceDefinitionTest.assertEquals((int)2, (int)choice.getOutputs().size());
        ChoiceDefinitionTest.assertEquals((Object)when1, choice.getOutputs().get(0));
        ChoiceDefinitionTest.assertEquals((Object)when2, choice.getOutputs().get(1));
        ChoiceDefinitionTest.assertEquals((int)2, (int)choice.getOutputs().size());
        int i = 0;
        for (ProcessorDefinition def : choice.getOutputs()) {
            if (i == 0) {
                ChoiceDefinitionTest.assertEquals((Object)when1, (Object)def);
            } else if (i == 1) {
                ChoiceDefinitionTest.assertEquals((Object)when2, (Object)def);
            }
            ++i;
        }
    }

    public void testChoiceOtherwiseAlwaysLast() throws Exception {
        ChoiceDefinition choice = new ChoiceDefinition();
        WhenDefinition when1 = new WhenDefinition(ChoiceDefinitionTest.body().contains((Object)"Camel"));
        WhenDefinition when2 = new WhenDefinition(ChoiceDefinitionTest.body().contains((Object)"Donkey"));
        OtherwiseDefinition other = new OtherwiseDefinition();
        choice.addOutput((ProcessorDefinition)when1);
        choice.addOutput((ProcessorDefinition)other);
        choice.addOutput((ProcessorDefinition)when2);
        ChoiceDefinitionTest.assertEquals((int)3, (int)choice.getOutputs().size());
        ChoiceDefinitionTest.assertEquals((Object)when1, choice.getOutputs().get(0));
        ChoiceDefinitionTest.assertEquals((Object)when2, choice.getOutputs().get(1));
        ChoiceDefinitionTest.assertEquals((Object)other, choice.getOutputs().get(2));
    }

    public void testChoiceOtherwiseAlwaysLastIterate() throws Exception {
        ChoiceDefinition choice = new ChoiceDefinition();
        WhenDefinition when1 = new WhenDefinition(ChoiceDefinitionTest.body().contains((Object)"Camel"));
        WhenDefinition when2 = new WhenDefinition(ChoiceDefinitionTest.body().contains((Object)"Donkey"));
        OtherwiseDefinition other = new OtherwiseDefinition();
        choice.addOutput((ProcessorDefinition)when1);
        choice.addOutput((ProcessorDefinition)other);
        choice.addOutput((ProcessorDefinition)when2);
        ChoiceDefinitionTest.assertEquals((int)3, (int)choice.getOutputs().size());
        ChoiceDefinitionTest.assertEquals((Object)when1, choice.getOutputs().get(0));
        ChoiceDefinitionTest.assertEquals((Object)when2, choice.getOutputs().get(1));
        ChoiceDefinitionTest.assertEquals((Object)other, choice.getOutputs().get(2));
        ChoiceDefinitionTest.assertEquals((int)3, (int)choice.getOutputs().size());
        int i = 0;
        for (ProcessorDefinition def : choice.getOutputs()) {
            if (i == 0) {
                ChoiceDefinitionTest.assertEquals((Object)when1, (Object)def);
            } else if (i == 1) {
                ChoiceDefinitionTest.assertEquals((Object)when2, (Object)def);
            } else {
                ChoiceDefinitionTest.assertEquals((Object)other, (Object)def);
            }
            ++i;
        }
    }

    public void testChoiceOutputRemoveFirst() throws Exception {
        ChoiceDefinition choice = new ChoiceDefinition();
        WhenDefinition when1 = new WhenDefinition(ChoiceDefinitionTest.body().contains((Object)"Camel"));
        WhenDefinition when2 = new WhenDefinition(ChoiceDefinitionTest.body().contains((Object)"Donkey"));
        OtherwiseDefinition other = new OtherwiseDefinition();
        choice.addOutput((ProcessorDefinition)when1);
        choice.addOutput((ProcessorDefinition)when2);
        choice.addOutput((ProcessorDefinition)other);
        ChoiceDefinitionTest.assertEquals((int)3, (int)choice.getOutputs().size());
        choice.getOutputs().remove(0);
        ChoiceDefinitionTest.assertEquals((int)2, (int)choice.getOutputs().size());
        ChoiceDefinitionTest.assertEquals((Object)when2, choice.getOutputs().get(0));
        ChoiceDefinitionTest.assertEquals((Object)other, choice.getOutputs().get(1));
    }

    public void testChoiceOutputRemoveLast() throws Exception {
        ChoiceDefinition choice = new ChoiceDefinition();
        WhenDefinition when1 = new WhenDefinition(ChoiceDefinitionTest.body().contains((Object)"Camel"));
        WhenDefinition when2 = new WhenDefinition(ChoiceDefinitionTest.body().contains((Object)"Donkey"));
        OtherwiseDefinition other = new OtherwiseDefinition();
        choice.addOutput((ProcessorDefinition)when1);
        choice.addOutput((ProcessorDefinition)when2);
        choice.addOutput((ProcessorDefinition)other);
        ChoiceDefinitionTest.assertEquals((int)3, (int)choice.getOutputs().size());
        choice.getOutputs().remove(2);
        ChoiceDefinitionTest.assertEquals((int)2, (int)choice.getOutputs().size());
        ChoiceDefinitionTest.assertEquals((Object)when1, choice.getOutputs().get(0));
        ChoiceDefinitionTest.assertEquals((Object)when2, choice.getOutputs().get(1));
    }

    public void testChoiceOutputSetFirst() throws Exception {
        ChoiceDefinition choice = new ChoiceDefinition();
        WhenDefinition when1 = new WhenDefinition(ChoiceDefinitionTest.body().contains((Object)"Camel"));
        WhenDefinition when2 = new WhenDefinition(ChoiceDefinitionTest.body().contains((Object)"Donkey"));
        WhenDefinition when3 = new WhenDefinition(ChoiceDefinitionTest.body().contains((Object)"Beer"));
        OtherwiseDefinition other = new OtherwiseDefinition();
        choice.addOutput((ProcessorDefinition)when1);
        choice.addOutput((ProcessorDefinition)when2);
        choice.addOutput((ProcessorDefinition)other);
        ChoiceDefinitionTest.assertEquals((int)3, (int)choice.getOutputs().size());
        choice.getOutputs().set(0, when3);
        ChoiceDefinitionTest.assertEquals((int)3, (int)choice.getOutputs().size());
        ChoiceDefinitionTest.assertEquals((Object)when3, choice.getOutputs().get(0));
        ChoiceDefinitionTest.assertEquals((Object)when2, choice.getOutputs().get(1));
        ChoiceDefinitionTest.assertEquals((Object)other, choice.getOutputs().get(2));
    }

    public void testChoiceOutputClear() throws Exception {
        ChoiceDefinition choice = new ChoiceDefinition();
        WhenDefinition when1 = new WhenDefinition(ChoiceDefinitionTest.body().contains((Object)"Camel"));
        WhenDefinition when2 = new WhenDefinition(ChoiceDefinitionTest.body().contains((Object)"Donkey"));
        choice.addOutput((ProcessorDefinition)when1);
        choice.addOutput((ProcessorDefinition)when2);
        ChoiceDefinitionTest.assertEquals((int)2, (int)choice.getOutputs().size());
        choice.getOutputs().clear();
        ChoiceDefinitionTest.assertEquals((int)0, (int)choice.getOutputs().size());
    }
}

