/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;

public class ManagedUnregisterProcessorTest
extends ManagementTestSupport {
    public void testUnregisterProcessor() throws Exception {
        if (ManagedUnregisterProcessorTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=processors,*"), null);
        ManagedUnregisterProcessorTest.assertEquals((int)2, (int)set.size());
        ObjectName on = set.iterator().next();
        ManagedUnregisterProcessorTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        String id = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedUnregisterProcessorTest.assertEquals((String)"camel-1", (String)id);
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedUnregisterProcessorTest.assertEquals((String)"route1", (String)routeId);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").setHeader("foo", (Expression)this.constant("bar"))).to("mock:result");
            }
        };
    }
}

