/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;

public class ManagedUnmarshalTest
extends ManagementTestSupport {
    public void testManageUnmarshal() throws Exception {
        if (ManagedUnmarshalTest.isPlatform("aix")) {
            return;
        }
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"123");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedUnmarshalTest.assertEquals((String)"route1", (String)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedUnmarshalTest.assertEquals((String)"camel-1", (String)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedUnmarshalTest.assertEquals((String)ServiceStatus.Started.name(), (String)state);
        String name = (String)mbeanServer.getAttribute(on, "DataFormatName");
        ManagedUnmarshalTest.assertEquals((String)"string", (String)name);
        String xml = (String)mbeanServer.invoke(on, "dumpProcessorAsXml", null, null);
        ManagedUnmarshalTest.assertTrue((boolean)xml.contains("<unmarshal"));
        ManagedUnmarshalTest.assertTrue((boolean)xml.contains("</unmarshal>"));
        ManagedUnmarshalTest.assertTrue((boolean)xml.contains("<string charset=\"iso-8859-1\"/>"));
        TabularData data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{false}, new String[]{"boolean"});
        ManagedUnmarshalTest.assertNotNull((Object)data);
        ManagedUnmarshalTest.assertEquals((int)2, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{true}, new String[]{"boolean"});
        ManagedUnmarshalTest.assertNotNull((Object)data);
        ManagedUnmarshalTest.assertEquals((int)4, (int)data.size());
        String json = (String)mbeanServer.invoke(on, "informationJson", null, null);
        ManagedUnmarshalTest.assertNotNull((Object)json);
        ManagedUnmarshalTest.assertTrue((boolean)json.contains("\"description\": \"Converts the message data received from the wire into a format that Apache Camel processors can consume"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").unmarshal().string("iso-8859-1").id("mysend")).to("mock:foo");
            }
        };
    }
}

