/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;

public class ManagedStatisticsLevelRoutesOnlyTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementStrategy().getManagementAgent().setStatisticsLevel(ManagementStatisticsLevel.RoutesOnly);
        return context;
    }

    public void testManageStatisticsRoutesOnly() throws Exception {
        if (ManagedStatisticsLevelRoutesOnlyTest.isPlatform("aix")) {
            return;
        }
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedStatisticsLevelRoutesOnlyTest.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        set = mbeanServer.queryNames(new ObjectName("*:type=processors,*"), null);
        ManagedStatisticsLevelRoutesOnlyTest.assertEquals((int)1, (int)set.size());
        ObjectName on2 = set.iterator().next();
        Long completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        ManagedStatisticsLevelRoutesOnlyTest.assertEquals((long)2L, (long)completed);
        Long completed2 = (Long)mbeanServer.getAttribute(on2, "ExchangesCompleted");
        ManagedStatisticsLevelRoutesOnlyTest.assertEquals((long)0L, (long)completed2);
        this.template.sendBody("direct:start", (Object)"Goodday World");
        completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        ManagedStatisticsLevelRoutesOnlyTest.assertEquals((long)3L, (long)completed);
        completed2 = (Long)mbeanServer.getAttribute(on2, "ExchangesCompleted");
        ManagedStatisticsLevelRoutesOnlyTest.assertEquals((long)0L, (long)completed2);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

