/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;

public class ManagedServiceUrlPathTest
extends ManagementTestSupport {
    private static final String JMXSERVICEURL = "service:jmx:rmi:///jndi/rmi://localhost:2113/foo/bar";
    private JMXConnector clientConnector;

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementStrategy().getManagementAgent().setServiceUrlPath("/foo/bar");
        context.getManagementStrategy().getManagementAgent().setRegistryPort(Integer.valueOf(2113));
        context.getManagementStrategy().getManagementAgent().setCreateConnector(Boolean.valueOf(true));
        return context;
    }

    @Override
    protected boolean canRunOnThisPlatform() {
        return false;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        try {
            if (this.clientConnector != null) {
                this.clientConnector.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void testConnectToJmx() throws Exception {
        if (ManagedServiceUrlPathTest.isPlatform("aix")) {
            return;
        }
        this.clientConnector = JMXConnectorFactory.connect(new JMXServiceURL(JMXSERVICEURL), null);
        MBeanServerConnection mbeanServer = this.clientConnector.getMBeanServerConnection();
        ObjectName name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"direct://start\"");
        String uri = (String)mbeanServer.getAttribute(name, "EndpointUri");
        ManagedServiceUrlPathTest.assertEquals((String)"direct://start", (String)uri);
        name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"log://foo\"");
        uri = (String)mbeanServer.getAttribute(name, "EndpointUri");
        ManagedServiceUrlPathTest.assertEquals((String)"log://foo", (String)uri);
        name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"mock://result\"");
        uri = (String)mbeanServer.getAttribute(name, "EndpointUri");
        ManagedServiceUrlPathTest.assertEquals((String)"mock://result", (String)uri);
        String id = (String)mbeanServer.getAttribute(name, "CamelId");
        ManagedServiceUrlPathTest.assertEquals((String)"camel-1", (String)id);
        Boolean singleton = (Boolean)mbeanServer.getAttribute(name, "Singleton");
        ManagedServiceUrlPathTest.assertEquals((Object)Boolean.TRUE, (Object)singleton);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
            }
        };
    }
}

