/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.processor.idempotent.MemoryIdempotentRepository;
import org.apache.camel.spi.IdempotentRepository;

public class ManagedMemoryIdempotentClearTest
extends ManagementTestSupport {
    protected Endpoint startEndpoint;
    protected MockEndpoint resultEndpoint;
    private IdempotentRepository<String> repo;

    public void testDuplicateMessagesAreFilteredOut() throws Exception {
        if (ManagedMemoryIdempotentClearTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> names = mbeanServer.queryNames(new ObjectName("org.apache.camel:type=services,*"), null);
        ObjectName on = null;
        for (ObjectName name : names) {
            if (!name.toString().contains("MemoryIdempotentRepository")) continue;
            on = name;
            break;
        }
        ManagedMemoryIdempotentClearTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        Integer size = (Integer)mbeanServer.getAttribute(on, "CacheSize");
        ManagedMemoryIdempotentClearTest.assertEquals((int)1, (int)size);
        ManagedMemoryIdempotentClearTest.assertFalse((boolean)this.repo.contains((Object)"1"));
        ManagedMemoryIdempotentClearTest.assertFalse((boolean)this.repo.contains((Object)"2"));
        ManagedMemoryIdempotentClearTest.assertFalse((boolean)this.repo.contains((Object)"3"));
        ManagedMemoryIdempotentClearTest.assertTrue((boolean)this.repo.contains((Object)"4"));
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"one", "two", "three"});
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("3", "three");
        this.resultEndpoint.assertIsSatisfied();
        ManagedMemoryIdempotentClearTest.assertTrue((boolean)this.repo.contains((Object)"1"));
        ManagedMemoryIdempotentClearTest.assertTrue((boolean)this.repo.contains((Object)"2"));
        ManagedMemoryIdempotentClearTest.assertTrue((boolean)this.repo.contains((Object)"3"));
        ManagedMemoryIdempotentClearTest.assertTrue((boolean)this.repo.contains((Object)"4"));
        size = (Integer)mbeanServer.getAttribute(on, "CacheSize");
        ManagedMemoryIdempotentClearTest.assertEquals((int)4, (int)size);
        mbeanServer.invoke(on, "clear", null, null);
        size = (Integer)mbeanServer.getAttribute(on, "CacheSize");
        ManagedMemoryIdempotentClearTest.assertEquals((int)0, (int)size);
        ManagedMemoryIdempotentClearTest.assertFalse((boolean)this.repo.contains((Object)"1"));
        ManagedMemoryIdempotentClearTest.assertFalse((boolean)this.repo.contains((Object)"2"));
        ManagedMemoryIdempotentClearTest.assertFalse((boolean)this.repo.contains((Object)"3"));
        ManagedMemoryIdempotentClearTest.assertFalse((boolean)this.repo.contains((Object)"4"));
    }

    public void testDuplicateMessagesCountAreCorrectlyCounted() throws Exception {
        if (ManagedMemoryIdempotentClearTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> names = mbeanServer.queryNames(new ObjectName("org.apache.camel:type=processors,*"), null);
        ObjectName on = null;
        for (ObjectName name : names) {
            if (!name.toString().contains("idempotentConsumer")) continue;
            on = name;
            break;
        }
        ManagedMemoryIdempotentClearTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        Long count = (Long)mbeanServer.getAttribute(on, "DuplicateMessageCount");
        ManagedMemoryIdempotentClearTest.assertEquals((long)0L, (long)count);
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"one", "two"});
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.resultEndpoint.assertIsSatisfied();
        count = (Long)mbeanServer.getAttribute(on, "DuplicateMessageCount");
        ManagedMemoryIdempotentClearTest.assertEquals((long)2L, (long)count);
        mbeanServer.invoke(on, "resetDuplicateMessageCount", null, null);
        count = (Long)mbeanServer.getAttribute(on, "DuplicateMessageCount");
        ManagedMemoryIdempotentClearTest.assertEquals((long)0L, (long)count);
        this.resetMocks();
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"five"});
        this.sendMessage("4", "four");
        this.sendMessage("4", "four");
        this.sendMessage("5", "five");
        this.sendMessage("4", "four");
        this.resultEndpoint.assertIsSatisfied();
        count = (Long)mbeanServer.getAttribute(on, "DuplicateMessageCount");
        ManagedMemoryIdempotentClearTest.assertEquals((long)3L, (long)count);
    }

    protected void sendMessage(final Object messageId, final Object body) {
        this.template.send(this.startEndpoint, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
                in.setHeader("messageId", messageId);
            }
        });
    }

    @Override
    protected void setUp() throws Exception {
        this.repo = MemoryIdempotentRepository.memoryIdempotentRepository();
        this.repo.add((Object)"4");
        super.setUp();
        this.startEndpoint = this.resolveMandatoryEndpoint("direct:start");
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").idempotentConsumer((Expression)this.header("messageId"), ManagedMemoryIdempotentClearTest.this.repo).to("mock:result");
            }
        };
    }
}

