/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.Predicate;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ExpressionNode;

public class ManagedFilterTest
extends ManagementTestSupport {
    public void testManageFilter() throws Exception {
        if (ManagedFilterTest.isPlatform("aix")) {
            return;
        }
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"123");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedFilterTest.assertEquals((String)"route1", (String)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedFilterTest.assertEquals((String)"camel-1", (String)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedFilterTest.assertEquals((String)ServiceStatus.Started.name(), (String)state);
        Long count = (Long)mbeanServer.getAttribute(on, "FilteredCount");
        ManagedFilterTest.assertEquals((long)1L, (long)count);
        String lan = (String)mbeanServer.getAttribute(on, "PredicateLanguage");
        ManagedFilterTest.assertEquals((String)"header", (String)lan);
        String uri = (String)mbeanServer.getAttribute(on, "Predicate");
        ManagedFilterTest.assertEquals((String)"foo", (String)uri);
        TabularData data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{false}, new String[]{"boolean"});
        ManagedFilterTest.assertNotNull((Object)data);
        ManagedFilterTest.assertEquals((int)2, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{true}, new String[]{"boolean"});
        ManagedFilterTest.assertNotNull((Object)data);
        ManagedFilterTest.assertEquals((int)4, (int)data.size());
        String json = (String)mbeanServer.invoke(on, "informationJson", null, null);
        ManagedFilterTest.assertNotNull((Object)json);
        ManagedFilterTest.assertTrue((boolean)json.contains("\"description\": \"Filter out messages based using a predicate"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)this.from("direct:start").filter((Predicate)this.header("foo")).id("mysend")).to("mock:foo");
            }
        };
    }
}

