/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.management.event.CamelContextStartedEvent;
import org.apache.camel.management.event.CamelContextStartingEvent;
import org.apache.camel.management.event.ExchangeCompletedEvent;
import org.apache.camel.management.event.ExchangeCreatedEvent;
import org.apache.camel.management.event.ExchangeFailureHandledEvent;
import org.apache.camel.management.event.ExchangeFailureHandlingEvent;
import org.apache.camel.management.event.ExchangeSendingEvent;
import org.apache.camel.management.event.ExchangeSentEvent;
import org.apache.camel.management.event.RouteAddedEvent;
import org.apache.camel.management.event.RouteStartedEvent;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.EventNotifierSupport;

public class EventNotifierFailureHandledEventsTest
extends ContextTestSupport {
    private static List<EventObject> events = new ArrayList<EventObject>();

    @Override
    public void setUp() throws Exception {
        events.clear();
        super.setUp();
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext((Registry)this.createRegistry());
        context.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

            public void notify(EventObject event) throws Exception {
                events.add(event);
            }

            public boolean isEnabled(EventObject event) {
                return true;
            }

            protected void doStart() throws Exception {
            }

            protected void doStop() throws Exception {
            }
        });
        return context;
    }

    public void testExchangeDeadLetterChannel() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead"));
                this.from("direct:start").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        EventNotifierFailureHandledEventsTest.assertEquals((int)12, (int)events.size());
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(CamelContextStartingEvent.class, events.get(0));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(RouteAddedEvent.class, events.get(1));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(RouteStartedEvent.class, events.get(2));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(CamelContextStartedEvent.class, events.get(3));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, events.get(4));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeCreatedEvent.class, events.get(5));
        ExchangeFailureHandlingEvent e0 = EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeFailureHandlingEvent.class, events.get(6));
        EventNotifierFailureHandledEventsTest.assertEquals((String)"should be DLC", (boolean)true, (boolean)e0.isDeadLetterChannel());
        EventNotifierFailureHandledEventsTest.assertEquals((String)"mock://dead", (String)e0.getDeadLetterUri());
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, events.get(7));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, events.get(8));
        ExchangeFailureHandledEvent e = EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeFailureHandledEvent.class, events.get(9));
        EventNotifierFailureHandledEventsTest.assertEquals((String)"should be DLC", (boolean)true, (boolean)e.isDeadLetterChannel());
        EventNotifierFailureHandledEventsTest.assertTrue((String)"should be marked as failure handled", (boolean)e.isHandled());
        EventNotifierFailureHandledEventsTest.assertFalse((String)"should not be continued", (boolean)e.isContinued());
        SendProcessor send = EventNotifierFailureHandledEventsTest.assertIsInstanceOf(SendProcessor.class, e.getFailureHandler());
        EventNotifierFailureHandledEventsTest.assertEquals((String)"mock://dead", (String)send.getDestination().getEndpointUri());
        EventNotifierFailureHandledEventsTest.assertEquals((String)"mock://dead", (String)e.getDeadLetterUri());
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeCompletedEvent.class, events.get(10));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, events.get(11));
        ExchangeSentEvent sent = (ExchangeSentEvent)events.get(11);
        EventNotifierFailureHandledEventsTest.assertEquals((String)"direct://start", (String)sent.getEndpoint().getEndpointUri());
    }

    public void testExchangeOnException() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(IllegalArgumentException.class).handled(true).to("mock:dead");
                this.from("direct:start").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        EventNotifierFailureHandledEventsTest.assertEquals((int)12, (int)events.size());
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(CamelContextStartingEvent.class, events.get(0));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(RouteAddedEvent.class, events.get(1));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(RouteStartedEvent.class, events.get(2));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(CamelContextStartedEvent.class, events.get(3));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, events.get(4));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeCreatedEvent.class, events.get(5));
        ExchangeFailureHandlingEvent e0 = EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeFailureHandlingEvent.class, events.get(6));
        EventNotifierFailureHandledEventsTest.assertEquals((String)"should NOT be DLC", (boolean)false, (boolean)e0.isDeadLetterChannel());
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, events.get(7));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, events.get(8));
        ExchangeFailureHandledEvent e = EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeFailureHandledEvent.class, events.get(9));
        EventNotifierFailureHandledEventsTest.assertEquals((String)"should NOT be DLC", (boolean)false, (boolean)e.isDeadLetterChannel());
        EventNotifierFailureHandledEventsTest.assertTrue((String)"should be marked as failure handled", (boolean)e.isHandled());
        EventNotifierFailureHandledEventsTest.assertFalse((String)"should not be continued", (boolean)e.isContinued());
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeCompletedEvent.class, events.get(10));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, events.get(11));
        ExchangeSentEvent sent = (ExchangeSentEvent)events.get(11);
        EventNotifierFailureHandledEventsTest.assertEquals((String)"direct://start", (String)sent.getEndpoint().getEndpointUri());
    }

    public void testExchangeDoTryDoCatch() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((TryDefinition)((TryDefinition)this.from("direct:start").doTry().throwException((Exception)new IllegalArgumentException("Damn"))).doCatch(IllegalArgumentException.class).to("mock:dead")).end();
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        EventNotifierFailureHandledEventsTest.assertEquals((int)12, (int)events.size());
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(CamelContextStartingEvent.class, events.get(0));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(RouteAddedEvent.class, events.get(1));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(RouteStartedEvent.class, events.get(2));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(CamelContextStartedEvent.class, events.get(3));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, events.get(4));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeCreatedEvent.class, events.get(5));
        ExchangeFailureHandlingEvent e0 = EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeFailureHandlingEvent.class, events.get(6));
        EventNotifierFailureHandledEventsTest.assertEquals((String)"should NOT be DLC", (boolean)false, (boolean)e0.isDeadLetterChannel());
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, events.get(7));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, events.get(8));
        ExchangeFailureHandledEvent e = EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeFailureHandledEvent.class, events.get(9));
        EventNotifierFailureHandledEventsTest.assertEquals((String)"should NOT be DLC", (boolean)false, (boolean)e.isDeadLetterChannel());
        EventNotifierFailureHandledEventsTest.assertFalse((String)"should not be marked as failure handled as it was continued instead", (boolean)e.isHandled());
        EventNotifierFailureHandledEventsTest.assertTrue((String)"should be continued", (boolean)e.isContinued());
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeCompletedEvent.class, events.get(10));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, events.get(11));
        ExchangeSentEvent sent = (ExchangeSentEvent)events.get(11);
        EventNotifierFailureHandledEventsTest.assertEquals((String)"direct://start", (String)sent.getEndpoint().getEndpointUri());
    }
}

