/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.EventObject;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.EventNotifierExchangeSentTest;
import org.apache.camel.management.event.ExchangeSendingEvent;
import org.apache.camel.model.RouteDefinition;

public class EventNotifierExchangeSentParallelTest
extends EventNotifierExchangeSentTest {
    @Override
    public void testExchangeSentRecipient() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:foo", (Object)"Hello World", "foo", (Object)"direct:cool,direct:start");
        this.assertMockEndpointsSatisfied();
        EventNotifierExchangeSentParallelTest.assertTrue((boolean)this.oneExchangeDone.matchesMockWaitTime());
        this.context.stop();
        EventNotifierExchangeSentParallelTest.assertTrue((String)("Should be 11 or more, was: " + events.size()), (events.size() >= 11 ? 1 : 0) != 0);
        int sent = 0;
        int sending = 0;
        for (EventObject event : events) {
            if (event instanceof ExchangeSendingEvent) {
                ++sending;
                continue;
            }
            ++sent;
        }
        EventNotifierExchangeSentParallelTest.assertTrue((String)("There should be 5 or more, was " + sending), (sending >= 5 ? 1 : 0) != 0);
        EventNotifierExchangeSentParallelTest.assertTrue((String)("There should be 5 or more, was " + sent), (sent >= 5 ? 1 : 0) != 0);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("log:foo")).to("direct:bar")).to("mock:result");
                this.from("direct:bar").delay(500L);
                this.from("direct:foo").recipientList((Expression)this.header("foo")).parallelProcessing();
                this.from("direct:cool").delay(1000L);
                this.from("direct:tap").wireTap("log:foo").to("mock:result");
            }
        };
    }
}

