/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointCompletionTest
extends ManagementTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointCompletionTest.class);

    public void testEndpointCompletion() throws Exception {
        if (EndpointCompletionTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=context,name=\"camel-1\"");
        EndpointCompletionTest.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        String componentName = "file";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.assertCompletion(mbeanServer, on, componentName, properties, "");
        this.assertCompletion(mbeanServer, on, componentName, properties, "po");
        this.assertCompletion(mbeanServer, on, componentName, properties, "/");
        this.assertCompletion(mbeanServer, on, componentName, properties, "/usr/local");
        this.assertCompletion(mbeanServer, on, componentName, properties, "/usr/local/");
        this.assertCompletion(mbeanServer, on, componentName, properties, "/usr/local/b");
    }

    public void testEndpointConfigurationJson() throws Exception {
        if (EndpointCompletionTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=context,name=\"camel-1\"");
        EndpointCompletionTest.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        this.assertParameterJsonSchema(mbeanServer, on, "bean");
        this.assertParameterJsonSchema(mbeanServer, on, "timer");
    }

    private List<String> assertCompletion(MBeanServer mbeanServer, ObjectName on, String componentName, Map<String, Object> properties, String completionText) throws Exception {
        Object[] params = new Object[]{componentName, properties, completionText};
        String[] signature = new String[]{"java.lang.String", "java.util.Map", "java.lang.String"};
        List completions = EndpointCompletionTest.assertIsInstanceOf(List.class, mbeanServer.invoke(on, "completeEndpointPath", params, signature));
        LOG.info("Component " + componentName + " with '" + completionText + "' Returned: " + completions);
        return completions;
    }

    private String assertParameterJsonSchema(MBeanServer mbeanServer, ObjectName on, String componentName) throws Exception {
        Object[] params = new Object[]{componentName};
        String[] signature = new String[]{"java.lang.String"};
        String answer = EndpointCompletionTest.assertIsInstanceOf(String.class, mbeanServer.invoke(on, "componentParameterJsonSchema", params, signature));
        LOG.info("Component " + componentName + " returned JSON: " + answer);
        ObjectMapper mapper = new ObjectMapper();
        HashMap data = (HashMap)mapper.readValue(answer, HashMap.class);
        LOG.info("Read JSON: " + data);
        return answer;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
            }
        };
    }
}

