/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.tokenizer;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.SplitDefinition;

public class TokenizeWrapLanguageTest
extends ContextTestSupport {
    public void testSendClosedTagMessageToTokenize() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"<?xml version='1.0' encoding='UTF-8'?><parent><child some_attr='a' anotherAttr='a'></child></parent>", "<?xml version='1.0' encoding='UTF-8'?><parent><child some_attr='b' anotherAttr='b'></child></parent>"});
        this.template.sendBody("direct:start", (Object)"<?xml version='1.0' encoding='UTF-8'?><parent><child some_attr='a' anotherAttr='a'></child><child some_attr='b' anotherAttr='b'></child></parent>");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendClosedTagWithLineBreaksMessageToTokenize() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"<?xml version='1.0' encoding='UTF-8'?>\n<parent>\n<child some_attr='a' anotherAttr='a'>\n</child></parent>", "<?xml version='1.0' encoding='UTF-8'?>\n<parent>\n<child some_attr='b' anotherAttr='b'>\n</child></parent>"});
        this.template.sendBody("direct:start", (Object)"<?xml version='1.0' encoding='UTF-8'?>\n<parent>\n<child some_attr='a' anotherAttr='a'>\n</child>\n<child some_attr='b' anotherAttr='b'>\n</child>\n</parent>");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendSelfClosingTagMessageToTokenize() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"<?xml version='1.0' encoding='UTF-8'?><parent><child some_attr='a' anotherAttr='a' /></parent>", "<?xml version='1.0' encoding='UTF-8'?><parent><child some_attr='b' anotherAttr='b' /></parent>"});
        this.template.sendBody("direct:start", (Object)"<?xml version='1.0' encoding='UTF-8'?><parent><child some_attr='a' anotherAttr='a' /><child some_attr='b' anotherAttr='b' /></parent>");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendMixedClosingTagMessageToTokenize() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"<?xml version='1.0' encoding='UTF-8'?><parent><child some_attr='a' anotherAttr='a'>ha</child></parent>", "<?xml version='1.0' encoding='UTF-8'?><parent><child some_attr='b' anotherAttr='b' /></parent>", "<?xml version='1.0' encoding='UTF-8'?><parent><child some_attr='c'></child></parent>"});
        this.template.sendBody("direct:start", (Object)"<?xml version='1.0' encoding='UTF-8'?><parent><child some_attr='a' anotherAttr='a'>ha</child><child some_attr='b' anotherAttr='b' /><child some_attr='c'></child></parent>");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendMixedClosingTagInsideMessageToTokenize() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"<parent><child name='child1'><grandchild name='grandchild1'/> <grandchild name='grandchild2'/></child></parent>", "<parent><child name='child2'><grandchild name='grandchild1'></grandchild><grandchild name='grandchild2'></grandchild></child></parent>"});
        this.template.sendBody("direct:start", (Object)"<parent><child name='child1'><grandchild name='grandchild1'/> <grandchild name='grandchild2'/></child><child name='child2'><grandchild name='grandchild1'></grandchild><grandchild name='grandchild2'></grandchild></child></parent>");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendNamespacedChildMessageToTokenize() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"<?xml version='1.0' encoding='UTF-8'?><parent><c:child xmlns:c='urn:c' some_attr='a' anotherAttr='a'></c:child></parent>", "<?xml version='1.0' encoding='UTF-8'?><parent><c:child xmlns:c='urn:c' some_attr='b' anotherAttr='b' /></parent>"});
        this.template.sendBody("direct:start", (Object)"<?xml version='1.0' encoding='UTF-8'?><parent><c:child xmlns:c='urn:c' some_attr='a' anotherAttr='a'></c:child><c:child xmlns:c='urn:c' some_attr='b' anotherAttr='b' /></parent>");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendNamespacedParentMessageToTokenize() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"<?xml version='1.0' encoding='UTF-8'?><c:parent xmlns:c='urn:c' xmlns:d=\"urn:d\"><c:child some_attr='a' anotherAttr='a'></c:child></c:parent>", "<?xml version='1.0' encoding='UTF-8'?><c:parent xmlns:c='urn:c' xmlns:d=\"urn:d\"><c:child some_attr='b' anotherAttr='b'/></c:parent>"});
        this.template.sendBody("direct:start", (Object)"<?xml version='1.0' encoding='UTF-8'?><c:parent xmlns:c='urn:c' xmlns:d=\"urn:d\"><c:child some_attr='a' anotherAttr='a'></c:child><c:child some_attr='b' anotherAttr='b'/></c:parent>");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendMoreParentsMessageToTokenize() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"<?xml version='1.0' encoding='UTF-8'?><g:greatgrandparent xmlns:g='urn:g'><grandparent><uncle/><aunt>emma</aunt><c:parent xmlns:c='urn:c' xmlns:d=\"urn:d\"><c:child some_attr='a' anotherAttr='a'></c:child></c:parent></grandparent></g:greatgrandparent>", "<?xml version='1.0' encoding='UTF-8'?><g:greatgrandparent xmlns:g='urn:g'><grandparent><uncle/><aunt>emma</aunt><c:parent xmlns:c='urn:c' xmlns:d=\"urn:d\"><c:child some_attr='b' anotherAttr='b'/></c:parent></grandparent></g:greatgrandparent>"});
        this.template.sendBody("direct:start", (Object)"<?xml version='1.0' encoding='UTF-8'?><g:greatgrandparent xmlns:g='urn:g'><grandparent><uncle/><aunt>emma</aunt><c:parent xmlns:c='urn:c' xmlns:d=\"urn:d\"><c:child some_attr='a' anotherAttr='a'></c:child><c:child some_attr='b' anotherAttr='b'/></c:parent></grandparent></g:greatgrandparent>");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((SplitDefinition)this.from("direct:start").split().tokenizeXML("child", "*")).to("mock:result")).end();
            }
        };
    }
}

