/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelAuthorizationException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.LanguageTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.component.bean.MethodNotFoundException;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.language.bean.RuntimeBeanExpressionException;
import org.apache.camel.language.simple.SimpleLanguage;
import org.apache.camel.language.simple.types.SimpleIllegalSyntaxException;
import org.apache.camel.language.simple.types.SimpleParserException;
import org.apache.camel.spi.Language;

public class SimpleTest
extends LanguageTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myAnimal", (Object)new Animal("Donkey", 17));
        return jndi;
    }

    public void testSimpleExpressionOrPredicate() throws Exception {
        Predicate predicate = SimpleLanguage.predicate((String)"${header.bar} == 123");
        SimpleTest.assertTrue((boolean)predicate.matches(this.exchange));
        predicate = SimpleLanguage.predicate((String)"${header.bar} == 124");
        SimpleTest.assertFalse((boolean)predicate.matches(this.exchange));
        Expression expression = SimpleLanguage.expression((String)"${body}");
        SimpleTest.assertEquals((String)"<hello id='m123'>world!</hello>", (String)((String)expression.evaluate(this.exchange, String.class)));
        expression = SimpleLanguage.simple((String)"${body}");
        SimpleTest.assertEquals((String)"<hello id='m123'>world!</hello>", (String)((String)expression.evaluate(this.exchange, String.class)));
        expression = SimpleLanguage.simple((String)"${body}", String.class);
        SimpleTest.assertEquals((String)"<hello id='m123'>world!</hello>", (String)((String)expression.evaluate(this.exchange, String.class)));
        expression = SimpleLanguage.simple((String)"${header.bar} == 123", Boolean.TYPE);
        SimpleTest.assertEquals((Object)Boolean.TRUE, (Object)expression.evaluate(this.exchange, Object.class));
        expression = SimpleLanguage.simple((String)"${header.bar} == 124", Boolean.TYPE);
        SimpleTest.assertEquals((Object)Boolean.FALSE, (Object)expression.evaluate(this.exchange, Object.class));
        expression = SimpleLanguage.simple((String)"${header.bar} == 123", Boolean.class);
        SimpleTest.assertEquals((Object)Boolean.TRUE, (Object)expression.evaluate(this.exchange, Object.class));
        expression = SimpleLanguage.simple((String)"${header.bar} == 124", Boolean.class);
        SimpleTest.assertEquals((Object)Boolean.FALSE, (Object)expression.evaluate(this.exchange, Object.class));
    }

    public void testResultType() throws Exception {
        SimpleTest.assertEquals((Object)123, (Object)SimpleLanguage.simple((String)"${header.bar}", Integer.TYPE).evaluate(this.exchange, Object.class));
        SimpleTest.assertEquals((Object)"123", (Object)SimpleLanguage.simple((String)"${header.bar}", String.class).evaluate(this.exchange, Object.class));
        SimpleTest.assertEquals(null, (Object)SimpleLanguage.simple((String)"${header.bar}", Date.class).evaluate(this.exchange, Object.class));
        SimpleTest.assertEquals(null, (Object)SimpleLanguage.simple((String)"${header.unknown}", String.class).evaluate(this.exchange, Object.class));
    }

    public void testRefExpression() throws Exception {
        this.assertExpressionResultInstanceOf("ref:myAnimal", Animal.class);
        this.assertExpressionResultInstanceOf("${ref:myAnimal}", Animal.class);
        this.assertExpression("ref:myAnimal", "Donkey");
        this.assertExpression("${ref:myAnimal}", "Donkey");
        this.assertExpression("ref:unknown", null);
        this.assertExpression("${ref:unknown}", null);
        this.assertExpression("Hello ${ref:myAnimal}", "Hello Donkey");
        this.assertExpression("Hello ${ref:unknown}", "Hello ");
    }

    public void testConstantExpression() throws Exception {
        this.assertExpression("Hello World", "Hello World");
    }

    public void testNull() throws Exception {
        SimpleTest.assertNull((Object)SimpleLanguage.simple((String)"${null}").evaluate(this.exchange, Object.class));
    }

    public void testSimpleFileDir() throws Exception {
        this.assertExpression("file:mydir", "file:mydir");
    }

    public void testEmptyExpression() throws Exception {
        this.assertExpression("", "");
        this.assertExpression(" ", " ");
        try {
            this.assertExpression(null, null);
            SimpleTest.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            SimpleTest.assertEquals((String)"expression must be specified", (String)e.getMessage());
        }
        this.assertPredicate("", false);
        this.assertPredicate(" ", false);
        try {
            this.assertPredicate(null, false);
            SimpleTest.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            SimpleTest.assertEquals((String)"expression must be specified", (String)e.getMessage());
        }
    }

    public void testExchangeExpression() throws Exception {
        Expression exp = SimpleLanguage.simple((String)"${exchange}");
        SimpleTest.assertNotNull((Object)exp);
        SimpleTest.assertEquals((Object)this.exchange, (Object)exp.evaluate(this.exchange, Object.class));
        this.assertExpression("exchange", this.exchange);
    }

    public void testExchangeOgnlExpression() throws Exception {
        Expression exp = SimpleLanguage.simple((String)"${exchange.exchangeId}");
        SimpleTest.assertNotNull((Object)exp);
        SimpleTest.assertEquals((Object)this.exchange.getExchangeId(), (Object)exp.evaluate(this.exchange, Object.class));
        this.assertExpression("exchange.exchangeId", this.exchange.getExchangeId());
        this.assertExpression("exchange.class.name", "org.apache.camel.impl.DefaultExchange");
    }

    public void testBodyExpression() throws Exception {
        Expression exp = SimpleLanguage.simple((String)"${body}");
        SimpleTest.assertNotNull((Object)exp);
    }

    public void testBodyExpressionUsingAlternativeStartToken() throws Exception {
        Expression exp = SimpleLanguage.simple((String)"$simple{body}");
        SimpleTest.assertNotNull((Object)exp);
    }

    public void testBodyExpressionNotStringType() throws Exception {
        this.exchange.getIn().setBody((Object)123);
        Expression exp = SimpleLanguage.simple((String)"${body}");
        SimpleTest.assertNotNull((Object)exp);
        Object val = exp.evaluate(this.exchange, Object.class);
        SimpleTest.assertIsInstanceOf(Integer.class, val);
        SimpleTest.assertEquals((Object)123, (Object)val);
    }

    public void testBodyExpressionWithArray() throws Exception {
        this.exchange.getIn().setBody((Object)new MyClass());
        Expression exp = SimpleLanguage.simple((String)"body.myArray");
        SimpleTest.assertNotNull((Object)exp);
        Object val = exp.evaluate(this.exchange, Object.class);
        SimpleTest.assertIsInstanceOf(Object[].class, val);
        exp = SimpleLanguage.simple((String)"body.myArray.length");
        SimpleTest.assertNotNull((Object)exp);
        val = exp.evaluate(this.exchange, Object.class);
        SimpleTest.assertIsInstanceOf(Integer.class, val);
        SimpleTest.assertEquals((Object)3, (Object)val);
    }

    public void testSimpleExpressions() throws Exception {
        this.assertExpression("exchangeId", this.exchange.getExchangeId());
        this.assertExpression("id", this.exchange.getIn().getMessageId());
        this.assertExpression("body", "<hello id='m123'>world!</hello>");
        this.assertExpression("in.body", "<hello id='m123'>world!</hello>");
        this.assertExpression("in.header.foo", "abc");
        this.assertExpression("in.headers.foo", "abc");
        this.assertExpression("header.foo", "abc");
        this.assertExpression("headers.foo", "abc");
        this.assertExpression("routeId", this.exchange.getFromRouteId());
        this.exchange.setFromRouteId("myRouteId");
        this.assertExpression("routeId", "myRouteId");
    }

    public void testTrimSimpleExpressions() throws Exception {
        this.assertExpression(" \texchangeId\n".trim(), this.exchange.getExchangeId());
        this.assertExpression("\nid\r".trim(), this.exchange.getIn().getMessageId());
        this.assertExpression("\t\r body".trim(), "<hello id='m123'>world!</hello>");
        this.assertExpression("\nin.body\r".trim(), "<hello id='m123'>world!</hello>");
    }

    public void testSimpleThreadName() throws Exception {
        String name = Thread.currentThread().getName();
        this.assertExpression("threadName", name);
        this.assertExpression("The name is ${threadName}", "The name is " + name);
    }

    public void testSimpleOutExpressions() throws Exception {
        this.exchange.getOut().setBody((Object)"Bye World");
        this.exchange.getOut().setHeader("quote", (Object)"Camel rocks");
        this.assertExpression("out.body", "Bye World");
        this.assertExpression("out.header.quote", "Camel rocks");
        this.assertExpression("out.headers.quote", "Camel rocks");
    }

    public void testSimplePropertyExpressions() throws Exception {
        this.exchange.setProperty("medal", (Object)"gold");
        this.assertExpression("property.medal", "gold");
    }

    public void testSimpleExchangePropertyExpressions() throws Exception {
        this.exchange.setProperty("medal", (Object)"gold");
        this.assertExpression("exchangeProperty.medal", "gold");
    }

    public void testSimpleSystemPropertyExpressions() throws Exception {
        System.setProperty("who", "I was here");
        this.assertExpression("sys.who", "I was here");
    }

    public void testSimpleSystemEnvironmentExpressions() throws Exception {
        String path = System.getenv("PATH");
        if (path != null) {
            this.assertExpression("sysenv.PATH", path);
        }
    }

    public void testSimpleCamelId() throws Exception {
        this.assertExpression("camelId", this.context.getName());
    }

    public void testOGNLBodyListAndMap() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cool", "Camel rocks");
        map.put("dude", "Hey dude");
        map.put("code", 4321);
        ArrayList<HashMap<String, Object>> lines = new ArrayList<HashMap<String, Object>>();
        lines.add(map);
        this.exchange.getIn().setBody(lines);
        this.assertExpression("${in.body[0][cool]}", "Camel rocks");
        this.assertExpression("${body[0][cool]}", "Camel rocks");
        this.assertExpression("${in.body[0][code]}", 4321);
        this.assertExpression("${body[0][code]}", 4321);
    }

    public void testOGNLBodyExpression() throws Exception {
        this.exchange.getIn().setBody((Object)"hello world");
        this.assertPredicate("${body} == 'hello world'", true);
        this.assertPredicate("${body.toUpperCase()} == 'HELLO WORLD'", true);
    }

    public void testOGNLCallReplace() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("cool", "Camel rocks");
        map.put("dude", "Hey dude");
        this.exchange.getIn().setHeaders(map);
        this.assertExpression("${headers.cool.replaceAll(\"rocks\", \"is so cool\")}", "Camel is so cool");
    }

    public void testOGNLBodyListAndMapAndMethod() throws Exception {
        HashMap<String, OrderLine> map = new HashMap<String, OrderLine>();
        map.put("camel", new OrderLine(123, "Camel in Action"));
        map.put("amq", new OrderLine(456, "ActiveMQ in Action"));
        ArrayList<HashMap<String, OrderLine>> lines = new ArrayList<HashMap<String, OrderLine>>();
        lines.add(map);
        this.exchange.getIn().setBody(lines);
        this.assertExpression("${in.body[0][camel].id}", 123);
        this.assertExpression("${in.body[0][camel].name}", "Camel in Action");
        this.assertExpression("${in.body[0][camel].getId}", 123);
        this.assertExpression("${in.body[0][camel].getName}", "Camel in Action");
        this.assertExpression("${body[0][camel].id}", 123);
        this.assertExpression("${body[0][camel].name}", "Camel in Action");
        this.assertExpression("${body[0][camel].getId}", 123);
        this.assertExpression("${body[0][camel].getName}", "Camel in Action");
    }

    public void testOGNLPropertyList() throws Exception {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Camel in Action");
        lines.add("ActiveMQ in Action");
        this.exchange.setProperty("wicket", lines);
        this.assertExpression("${exchangeProperty.wicket[0]}", "Camel in Action");
        this.assertExpression("${exchangeProperty.wicket[1]}", "ActiveMQ in Action");
        try {
            this.assertExpression("${exchangeProperty.wicket[2]}", "");
            SimpleTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception e) {
            IndexOutOfBoundsException cause = SimpleTest.assertIsInstanceOf(IndexOutOfBoundsException.class, e.getCause());
            SimpleTest.assertEquals((String)"Index: 2, Size: 2", (String)cause.getMessage());
        }
        this.assertExpression("${exchangeProperty.unknown[cool]}", null);
    }

    public void testOGNLPropertyLinesList() throws Exception {
        ArrayList<OrderLine> lines = new ArrayList<OrderLine>();
        lines.add(new OrderLine(123, "Camel in Action"));
        lines.add(new OrderLine(456, "ActiveMQ in Action"));
        this.exchange.setProperty("wicket", lines);
        this.assertExpression("${exchangeProperty.wicket[0].getId}", 123);
        this.assertExpression("${exchangeProperty.wicket[1].getName}", "ActiveMQ in Action");
        try {
            this.assertExpression("${exchangeProperty.wicket[2]}", "");
            SimpleTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception e) {
            IndexOutOfBoundsException cause = SimpleTest.assertIsInstanceOf(IndexOutOfBoundsException.class, e.getCause());
            SimpleTest.assertEquals((String)"Index: 2, Size: 2", (String)cause.getMessage());
        }
        this.assertExpression("${property.unknown[cool]}", null);
    }

    public void testOGNLPropertyMap() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cool", "Camel rocks");
        map.put("dude", "Hey dude");
        map.put("code", 4321);
        this.exchange.setProperty("wicket", map);
        this.assertExpression("${property.wicket[cool]}", "Camel rocks");
        this.assertExpression("${property.wicket[dude]}", "Hey dude");
        this.assertExpression("${property.wicket[unknown]}", null);
        this.assertExpression("${property.wicket[code]}", 4321);
        this.assertExpression("${property?.unknown[cool]}", null);
        this.assertExpression("${property.unknown[cool]}", null);
    }

    public void testOGNLExchangePropertyMap() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cool", "Camel rocks");
        map.put("dude", "Hey dude");
        map.put("code", 4321);
        this.exchange.setProperty("wicket", map);
        this.assertExpression("${exchangeProperty.wicket[cool]}", "Camel rocks");
        this.assertExpression("${exchangeProperty.wicket[dude]}", "Hey dude");
        this.assertExpression("${exchangeProperty.wicket[unknown]}", null);
        this.assertExpression("${exchangeProperty.wicket[code]}", 4321);
        this.assertExpression("${exchangeProperty?.unknown[cool]}", null);
        this.assertExpression("${exchangeProperty.unknown[cool]}", null);
    }

    public void testOGNLPropertyMapWithDot() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("this.code", "This code");
        this.exchange.setProperty("wicket", map);
        this.assertExpression("${exchangeProperty.wicket[this.code]}", "This code");
    }

    public void testOGNLPropertyMapNotMap() throws Exception {
        try {
            this.assertExpression("${exchangeProperty.foobar[bar]}", null);
            SimpleTest.fail((String)"Should have thrown an exception");
        }
        catch (RuntimeBeanExpressionException e) {
            IndexOutOfBoundsException cause = SimpleTest.assertIsInstanceOf(IndexOutOfBoundsException.class, e.getCause());
            SimpleTest.assertEquals((String)"Key: bar not found in bean: cba of type: java.lang.String using OGNL path [[bar]]", (String)cause.getMessage());
        }
    }

    public void testOGNLPropertyMapIllegalSyntax() throws Exception {
        try {
            this.assertExpression("${property.foobar[bar}", null);
            SimpleTest.fail((String)"Should have thrown an exception");
        }
        catch (ExpressionIllegalSyntaxException e) {
            SimpleTest.assertTrue((boolean)e.getMessage().startsWith("Valid syntax: ${exchangeProperty.OGNL} was: property.foobar[bar at location 0"));
        }
    }

    public void testOGNLExchangePropertyMapIllegalSyntax() throws Exception {
        try {
            this.assertExpression("${exchangeProperty.foobar[bar}", null);
            SimpleTest.fail((String)"Should have thrown an exception");
        }
        catch (ExpressionIllegalSyntaxException e) {
            SimpleTest.assertTrue((boolean)e.getMessage().startsWith("Valid syntax: ${exchangeProperty.OGNL} was: exchangeProperty.foobar[bar at location 0"));
        }
    }

    public void testOGNLHeaderEmptyTest() throws Exception {
        this.exchange.getIn().setHeader("beer", (Object)"");
        this.assertPredicate("${header.beer} == ''", true);
        this.assertPredicate("${header.beer} == \"\"", true);
        this.assertPredicate("${header.beer} == ' '", false);
        this.assertPredicate("${header.beer} == \" \"", false);
        this.exchange.getIn().setHeader("beer", (Object)" ");
        this.assertPredicate("${header.beer} == ''", false);
        this.assertPredicate("${header.beer} == \"\"", false);
        this.assertPredicate("${header.beer} == ' '", true);
        this.assertPredicate("${header.beer} == \" \"", true);
        this.assertPredicate("${header.beer.toString().trim()} == ''", true);
        this.assertPredicate("${header.beer.toString().trim()} == \"\"", true);
        this.exchange.getIn().setHeader("beer", (Object)"   ");
        this.assertPredicate("${header.beer.trim()} == ''", true);
        this.assertPredicate("${header.beer.trim()} == \"\"", true);
    }

    public void testDateExpressions() throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.set(1974, 3, 20);
        this.exchange.getIn().setHeader("birthday", (Object)cal.getTime());
        this.assertExpression("date:header.birthday:yyyyMMdd", "19740420");
        try {
            this.assertExpression("date:yyyyMMdd", "19740420");
            SimpleTest.fail((String)"Should thrown an exception");
        }
        catch (SimpleParserException e) {
            SimpleTest.assertEquals((String)"Valid syntax: ${date:command:pattern} was: date:yyyyMMdd", (String)e.getMessage());
        }
    }

    public void testDateAndTimeExpressions() throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.set(1974, 3, 20, 8, 55, 47);
        cal.set(14, 123);
        this.exchange.getIn().setHeader("birthday", (Object)cal.getTime());
        this.assertExpression("date:header.birthday:yyyy-MM-dd'T'HH:mm:ss:SSS", "1974-04-20T08:55:47:123");
    }

    public void testLanguagesInContext() throws Exception {
        this.assertExpression("id", this.exchange.getIn().getMessageId());
        SimpleTest.assertEquals((int)1, (int)this.context.getLanguageNames().size());
        SimpleTest.assertEquals((String)"simple", (String)((String)this.context.getLanguageNames().get(0)));
    }

    public void testComplexExpressions() throws Exception {
        this.assertExpression("hey ${in.header.foo}", "hey abc");
        this.assertExpression("hey ${in.header.foo}!", "hey abc!");
        this.assertExpression("hey ${in.header.foo}-${in.header.foo}!", "hey abc-abc!");
        this.assertExpression("hey ${in.header.foo}${in.header.foo}", "hey abcabc");
        this.assertExpression("${in.header.foo}${in.header.foo}", "abcabc");
        this.assertExpression("${in.header.foo}", "abc");
        this.assertExpression("${in.header.foo}!", "abc!");
    }

    public void testComplexExpressionsUsingAlternativeStartToken() throws Exception {
        this.assertExpression("hey $simple{in.header.foo}", "hey abc");
        this.assertExpression("hey $simple{in.header.foo}!", "hey abc!");
        this.assertExpression("hey $simple{in.header.foo}-$simple{in.header.foo}!", "hey abc-abc!");
        this.assertExpression("hey $simple{in.header.foo}$simple{in.header.foo}", "hey abcabc");
        this.assertExpression("$simple{in.header.foo}$simple{in.header.foo}", "abcabc");
        this.assertExpression("$simple{in.header.foo}", "abc");
        this.assertExpression("$simple{in.header.foo}!", "abc!");
    }

    public void testInvalidComplexExpression() throws Exception {
        try {
            this.assertExpression("hey ${foo", "bad expression!");
            SimpleTest.fail((String)"Should have thrown an exception!");
        }
        catch (SimpleIllegalSyntaxException e) {
            SimpleTest.assertEquals((int)8, (int)e.getIndex());
        }
    }

    public void testPredicates() throws Exception {
        this.assertPredicate("body");
        this.assertPredicate("header.foo");
        this.assertPredicate("header.madeUpHeader", false);
    }

    public void testExceptionMessage() throws Exception {
        this.exchange.setException((Throwable)new IllegalArgumentException("Just testing"));
        this.assertExpression("exception.message", "Just testing");
        this.assertExpression("Hello ${exception.message} World", "Hello Just testing World");
    }

    public void testExceptionStacktrace() throws Exception {
        this.exchange.setException((Throwable)new IllegalArgumentException("Just testing"));
        String out = (String)SimpleLanguage.simple((String)"exception.stacktrace").evaluate(this.exchange, String.class);
        SimpleTest.assertNotNull((Object)out);
        SimpleTest.assertTrue((boolean)out.startsWith("java.lang.IllegalArgumentException: Just testing"));
        SimpleTest.assertTrue((boolean)out.contains("at org.apache.camel.language."));
    }

    public void testException() throws Exception {
        this.exchange.setException((Throwable)new IllegalArgumentException("Just testing"));
        Exception out = (Exception)SimpleLanguage.simple((String)"exception").evaluate(this.exchange, Exception.class);
        SimpleTest.assertNotNull((Object)out);
        SimpleTest.assertIsInstanceOf(IllegalArgumentException.class, out);
        SimpleTest.assertEquals((String)"Just testing", (String)out.getMessage());
    }

    public void testBodyAs() throws Exception {
        this.assertExpression("${bodyAs(String)}", "<hello id='m123'>world!</hello>");
        this.assertExpression("${bodyAs('String')}", "<hello id='m123'>world!</hello>");
        this.exchange.getIn().setBody(null);
        this.assertExpression("${bodyAs('String')}", null);
        this.exchange.getIn().setBody((Object)456);
        this.assertExpression("${bodyAs(Integer)}", 456);
        this.assertExpression("${bodyAs(int)}", 456);
        this.assertExpression("${bodyAs('int')}", 456);
        try {
            this.assertExpression("${bodyAs(XXX)}", 456);
            SimpleTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            SimpleTest.assertIsInstanceOf(ClassNotFoundException.class, e.getCause());
        }
        this.exchange.getIn().setBody((Object)"hello");
        try {
            this.assertExpression("${bodyAs(String).test}", "hello.test");
            SimpleTest.fail((String)"should have thrown an exception");
        }
        catch (SimpleIllegalSyntaxException e) {
            SimpleTest.assertTrue((String)"Get a wrong message", (e.getMessage().indexOf("bodyAs(String).test") > 0 ? 1 : 0) != 0);
        }
    }

    public void testMandatoryBodyAs() throws Exception {
        this.assertExpression("${mandatoryBodyAs(String)}", "<hello id='m123'>world!</hello>");
        this.assertExpression("${mandatoryBodyAs('String')}", "<hello id='m123'>world!</hello>");
        this.exchange.getIn().setBody(null);
        try {
            this.assertExpression("${mandatoryBodyAs('String')}", "");
            SimpleTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            SimpleTest.assertIsInstanceOf(InvalidPayloadException.class, e.getCause());
        }
        this.exchange.getIn().setBody((Object)456);
        this.assertExpression("${mandatoryBodyAs(Integer)}", 456);
        this.assertExpression("${mandatoryBodyAs(int)}", 456);
        this.assertExpression("${mandatoryBodyAs('int')}", 456);
        try {
            this.assertExpression("${mandatoryBodyAs(XXX)}", 456);
            SimpleTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            SimpleTest.assertIsInstanceOf(ClassNotFoundException.class, e.getCause());
        }
        try {
            this.assertExpression("${mandatoryBodyAs(String).test}", "hello.test");
            SimpleTest.fail((String)"should have thrown an exception");
        }
        catch (SimpleIllegalSyntaxException e) {
            SimpleTest.assertTrue((String)"Get a wrong message", (e.getMessage().indexOf("mandatoryBodyAs(String).test") > 0 ? 1 : 0) != 0);
        }
    }

    public void testHeaderEmptyBody() throws Exception {
        this.exchange.getIn().setBody(null);
        this.assertExpression("header.foo", "abc");
        this.assertExpression("headers.foo", "abc");
        this.assertExpression("in.header.foo", "abc");
        this.assertExpression("in.headers.foo", "abc");
        this.assertExpression("${header.foo}", "abc");
        this.assertExpression("${headers.foo}", "abc");
        this.assertExpression("${in.header.foo}", "abc");
        this.assertExpression("${in.headers.foo}", "abc");
    }

    public void testHeadersWithBracket() throws Exception {
        this.assertExpression("headers[foo]", "abc");
        this.assertExpression("${headers[foo]}", "abc");
        this.assertExpression("${in.headers[foo]}", "abc");
    }

    public void testIsInstanceOfEmptyBody() throws Exception {
        this.exchange.getIn().setBody(null);
        try {
            this.assertPredicate("${body} is null", false);
            SimpleTest.fail((String)"Should have thrown an exception");
        }
        catch (SimpleIllegalSyntaxException e) {
            SimpleTest.assertEquals((int)11, (int)e.getIndex());
        }
    }

    public void testHeaders() throws Exception {
        Map headers = this.exchange.getIn().getHeaders();
        SimpleTest.assertEquals((int)2, (int)headers.size());
        this.assertExpression("headers", headers);
        this.assertExpression("${headers}", headers);
        this.assertExpression("in.headers", headers);
        this.assertExpression("${in.headers}", headers);
    }

    public void testHeaderKeyWithSpace() throws Exception {
        Map headers = this.exchange.getIn().getHeaders();
        headers.put("some key", "Some Value");
        SimpleTest.assertEquals((int)3, (int)headers.size());
        this.assertExpression("${headerAs(foo,String)}", "abc");
        this.assertExpression("${headerAs(some key,String)}", "Some Value");
        this.assertExpression("${headerAs('some key',String)}", "Some Value");
        this.assertExpression("${header[foo]}", "abc");
        this.assertExpression("${header[some key]}", "Some Value");
        this.assertExpression("${header['some key']}", "Some Value");
        this.assertExpression("${headers[foo]}", "abc");
        this.assertExpression("${headers[some key]}", "Some Value");
        this.assertExpression("${headers['some key']}", "Some Value");
    }

    public void testHeaderAs() throws Exception {
        this.assertExpression("${headerAs(foo,String)}", "abc");
        this.assertExpression("${headerAs(bar,int)}", 123);
        this.assertExpression("${headerAs(bar, int)}", 123);
        this.assertExpression("${headerAs('bar', int)}", 123);
        this.assertExpression("${headerAs('bar','int')}", 123);
        this.assertExpression("${headerAs('bar','Integer')}", 123);
        this.assertExpression("${headerAs('bar',\"int\")}", 123);
        this.assertExpression("${headerAs(bar,String)}", "123");
        this.assertExpression("${headerAs(unknown,String)}", null);
        try {
            this.assertExpression("${headerAs(unknown String)}", null);
            SimpleTest.fail((String)"Should have thrown an exception");
        }
        catch (ExpressionIllegalSyntaxException e) {
            SimpleTest.assertTrue((boolean)e.getMessage().startsWith("Valid syntax: ${headerAs(key, type)} was: headerAs(unknown String)"));
        }
        try {
            this.assertExpression("${headerAs(fool,String).test}", null);
            SimpleTest.fail((String)"Should have thrown an exception");
        }
        catch (ExpressionIllegalSyntaxException e) {
            SimpleTest.assertTrue((boolean)e.getMessage().startsWith("Valid syntax: ${headerAs(key, type)} was: headerAs(fool,String).test"));
        }
        try {
            this.assertExpression("${headerAs(bar,XXX)}", 123);
            SimpleTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            SimpleTest.assertIsInstanceOf(ClassNotFoundException.class, e.getCause());
        }
    }

    public void testIllegalSyntax() throws Exception {
        try {
            this.assertExpression("hey ${xxx} how are you?", "");
            SimpleTest.fail((String)"Should have thrown an exception");
        }
        catch (ExpressionIllegalSyntaxException e) {
            SimpleTest.assertTrue((boolean)e.getMessage().startsWith("Unknown function: xxx at location 4"));
        }
        try {
            this.assertExpression("${xxx}", "");
            SimpleTest.fail((String)"Should have thrown an exception");
        }
        catch (ExpressionIllegalSyntaxException e) {
            SimpleTest.assertTrue((boolean)e.getMessage().startsWith("Unknown function: xxx at location 0"));
        }
        try {
            this.assertExpression("${bodyAs(xxx}", "");
            SimpleTest.fail((String)"Should have thrown an exception");
        }
        catch (ExpressionIllegalSyntaxException e) {
            SimpleTest.assertTrue((boolean)e.getMessage().startsWith("Valid syntax: ${bodyAs(type)} was: bodyAs(xxx"));
        }
    }

    public void testOGNLHeaderList() throws Exception {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Camel in Action");
        lines.add("ActiveMQ in Action");
        this.exchange.getIn().setHeader("wicket", lines);
        this.assertExpression("${header.wicket[0]}", "Camel in Action");
        this.assertExpression("${header.wicket[1]}", "ActiveMQ in Action");
        try {
            this.assertExpression("${header.wicket[2]}", "");
            SimpleTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception e) {
            IndexOutOfBoundsException cause = SimpleTest.assertIsInstanceOf(IndexOutOfBoundsException.class, e.getCause());
            SimpleTest.assertEquals((String)"Index: 2, Size: 2", (String)cause.getMessage());
        }
        this.assertExpression("${header.unknown[cool]}", null);
    }

    public void testOGNLHeaderLinesList() throws Exception {
        ArrayList<OrderLine> lines = new ArrayList<OrderLine>();
        lines.add(new OrderLine(123, "Camel in Action"));
        lines.add(new OrderLine(456, "ActiveMQ in Action"));
        this.exchange.getIn().setHeader("wicket", lines);
        this.assertExpression("${header.wicket[0].getId}", 123);
        this.assertExpression("${header.wicket[1].getName}", "ActiveMQ in Action");
        try {
            this.assertExpression("${header.wicket[2]}", "");
            SimpleTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception e) {
            IndexOutOfBoundsException cause = SimpleTest.assertIsInstanceOf(IndexOutOfBoundsException.class, e.getCause());
            SimpleTest.assertEquals((String)"Index: 2, Size: 2", (String)cause.getMessage());
        }
        this.assertExpression("${header.unknown[cool]}", null);
    }

    public void testOGNLHeaderMap() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cool", "Camel rocks");
        map.put("dude", "Hey dude");
        map.put("code", 4321);
        this.exchange.getIn().setHeader("wicket", map);
        this.assertExpression("${header.wicket[cool]}", "Camel rocks");
        this.assertExpression("${header.wicket[dude]}", "Hey dude");
        this.assertExpression("${header.wicket[unknown]}", null);
        this.assertExpression("${header.wicket[code]}", 4321);
        this.assertExpression("${header?.unknown[cool]}", null);
        this.assertExpression("${header.unknown[cool]}", null);
    }

    public void testOGNLHeaderMapWithDot() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("this.code", "This code");
        this.exchange.getIn().setHeader("wicket", map);
        this.assertExpression("${header.wicket[this.code]}", "This code");
    }

    public void testOGNLHeaderMapNotMap() throws Exception {
        try {
            this.assertExpression("${header.foo[bar]}", null);
            SimpleTest.fail((String)"Should have thrown an exception");
        }
        catch (RuntimeBeanExpressionException e) {
            IndexOutOfBoundsException cause = SimpleTest.assertIsInstanceOf(IndexOutOfBoundsException.class, e.getCause());
            SimpleTest.assertEquals((String)"Key: bar not found in bean: abc of type: java.lang.String using OGNL path [[bar]]", (String)cause.getMessage());
        }
    }

    public void testOGNLHeaderMapIllegalSyntax() throws Exception {
        try {
            this.assertExpression("${header.foo[bar}", null);
            SimpleTest.fail((String)"Should have thrown an exception");
        }
        catch (ExpressionIllegalSyntaxException e) {
            SimpleTest.assertTrue((boolean)e.getMessage().startsWith("Valid syntax: ${header.name[key]} was: header.foo[bar"));
        }
    }

    public void testBodyOGNLAsMap() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("foo", "Camel");
        map.put("bar", 6);
        this.exchange.getIn().setBody(map);
        this.assertExpression("${in.body[foo]}", "Camel");
        this.assertExpression("${in.body[bar]}", 6);
    }

    public void testBodyOGNLAsMapWithDot() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo.bar", "Camel");
        this.exchange.getIn().setBody(map);
        this.assertExpression("${in.body[foo.bar]}", "Camel");
    }

    public void testBodyOGNLAsMapShorthand() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("foo", "Camel");
        map.put("bar", 6);
        this.exchange.getIn().setBody(map);
        this.assertExpression("${body[foo]}", "Camel");
        this.assertExpression("${body[bar]}", 6);
    }

    public void testBodyOGNLSimple() throws Exception {
        Animal camel = new Animal("Camel", 6);
        this.exchange.getIn().setBody((Object)camel);
        this.assertExpression("${in.body.getName}", "Camel");
        this.assertExpression("${in.body.getAge}", 6);
    }

    public void testExceptionOGNLSimple() throws Exception {
        this.exchange.getIn().setHeader("CamelAuthenticationFailurePolicyId", (Object)"myPolicy");
        this.exchange.setProperty("CamelExceptionCaught", (Object)new CamelAuthorizationException("The camel authorization exception", this.exchange));
        this.assertExpression("${exception.getPolicyId}", "myPolicy");
    }

    public void testBodyOGNLSimpleShorthand() throws Exception {
        Animal camel = new Animal("Camel", 6);
        this.exchange.getIn().setBody((Object)camel);
        this.assertExpression("${in.body.name}", "Camel");
        this.assertExpression("${in.body.age}", 6);
    }

    public void testBodyOGNLSimpleOperator() throws Exception {
        Animal tiger = new Animal("Tony the Tiger", 13);
        Animal camel = new Animal("Camel", 6);
        camel.setFriend(tiger);
        this.exchange.getIn().setBody((Object)camel);
        this.assertPredicate("${in.body.getName} contains 'Camel'", true);
        this.assertPredicate("${in.body.getName} contains 'Tiger'", false);
        this.assertPredicate("${in.body.getAge} < 10", true);
        this.assertPredicate("${in.body.getAge} > 10", false);
        this.assertPredicate("${in.body.getAge} <= '6'", true);
        this.assertPredicate("${in.body.getAge} > '6'", false);
        this.assertPredicate("${in.body.getAge} < ${body.getFriend.getAge}", true);
        this.assertPredicate("${in.body.getFriend.isDangerous} == true", true);
    }

    public void testBodyOGNLSimpleOperatorShorthand() throws Exception {
        Animal tiger = new Animal("Tony the Tiger", 13);
        Animal camel = new Animal("Camel", 6);
        camel.setFriend(tiger);
        this.exchange.getIn().setBody((Object)camel);
        this.assertPredicate("${in.body.name} contains 'Camel'", true);
        this.assertPredicate("${in.body.name} contains 'Tiger'", false);
        this.assertPredicate("${in.body.age} < 10", true);
        this.assertPredicate("${in.body.age} > 10", false);
        this.assertPredicate("${in.body.age} <= '6'", true);
        this.assertPredicate("${in.body.age} > '6'", false);
        this.assertPredicate("${in.body.age} < ${body.friend.age}", true);
        this.assertPredicate("${in.body.friend.dangerous} == true", true);
    }

    public void testBodyOGNLNested() throws Exception {
        Animal tiger = new Animal("Tony the Tiger", 13);
        Animal camel = new Animal("Camel", 6);
        camel.setFriend(tiger);
        this.exchange.getIn().setBody((Object)camel);
        this.assertExpression("${in.body.getName}", "Camel");
        this.assertExpression("${in.body.getAge}", 6);
        this.assertExpression("${in.body.getFriend.getName}", "Tony the Tiger");
        this.assertExpression("${in.body.getFriend.getAge}", "13");
    }

    public void testBodyOGNLNestedShorthand() throws Exception {
        Animal tiger = new Animal("Tony the Tiger", 13);
        Animal camel = new Animal("Camel", 6);
        camel.setFriend(tiger);
        this.exchange.getIn().setBody((Object)camel);
        this.assertExpression("${in.body.name}", "Camel");
        this.assertExpression("${in.body.age}", 6);
        this.assertExpression("${in.body.friend.name}", "Tony the Tiger");
        this.assertExpression("${in.body.friend.age}", "13");
    }

    public void testBodyOGNLOrderList() throws Exception {
        ArrayList<OrderLine> lines = new ArrayList<OrderLine>();
        lines.add(new OrderLine(123, "Camel in Action"));
        lines.add(new OrderLine(456, "ActiveMQ in Action"));
        Order order = new Order(lines);
        this.exchange.getIn().setBody((Object)order);
        this.assertExpression("${in.body.getLines[0].getId}", 123);
        this.assertExpression("${in.body.getLines[0].getName}", "Camel in Action");
        this.assertExpression("${in.body.getLines[1].getId}", 456);
        this.assertExpression("${in.body.getLines[1].getName}", "ActiveMQ in Action");
        this.assertExpression("${in.body.getLines[last].getId}", 456);
        this.assertExpression("${in.body.getLines[last].getName}", "ActiveMQ in Action");
        this.assertExpression("${in.body.getLines[last-1].getId}", 123);
        this.assertExpression("${in.body.getLines[last-1].getName}", "Camel in Action");
    }

    public void testBodyOGNLOrderListShorthand() throws Exception {
        ArrayList<OrderLine> lines = new ArrayList<OrderLine>();
        lines.add(new OrderLine(123, "Camel in Action"));
        lines.add(new OrderLine(456, "ActiveMQ in Action"));
        Order order = new Order(lines);
        this.exchange.getIn().setBody((Object)order);
        this.assertExpression("${in.body.lines[0].id}", 123);
        this.assertExpression("${in.body.lines[0].name}", "Camel in Action");
        this.assertExpression("${in.body.lines[1].id}", 456);
        this.assertExpression("${in.body.lines[1].name}", "ActiveMQ in Action");
        this.assertExpression("${in.body.lines[last].id}", 456);
        this.assertExpression("${in.body.lines[last].name}", "ActiveMQ in Action");
        this.assertExpression("${in.body.lines[last-1].id}", 123);
        this.assertExpression("${in.body.lines[last-1].name}", "Camel in Action");
        this.assertExpression("${in.body.lines.size}", 2);
    }

    public void testBodyOGNLListMap() throws Exception {
        ArrayList grid = new ArrayList();
        LinkedHashMap<String, String> cells = new LinkedHashMap<String, String>();
        cells.put("ABC", "123");
        cells.put("DEF", "456");
        grid.add(cells);
        LinkedHashMap<String, String> cells2 = new LinkedHashMap<String, String>();
        cells2.put("HIJ", "789");
        grid.add(cells2);
        this.exchange.getIn().setBody(grid);
        this.assertExpression("${in.body[0][ABC]}", "123");
        this.assertExpression("${in.body[0][DEF]}", "456");
        this.assertExpression("${in.body[0]['ABC']}", "123");
        this.assertExpression("${in.body[0]['DEF']}", "456");
        this.assertExpression("${in.body[1][HIJ]}", "789");
        this.assertExpression("${in.body[1]['HIJ']}", "789");
    }

    public void testBodyOGNLList() throws Exception {
        ArrayList<OrderLine> lines = new ArrayList<OrderLine>();
        lines.add(new OrderLine(123, "Camel in Action"));
        lines.add(new OrderLine(456, "ActiveMQ in Action"));
        this.exchange.getIn().setBody(lines);
        this.assertExpression("${in.body[0].getId}", 123);
        this.assertExpression("${in.body[0].getName}", "Camel in Action");
        this.assertExpression("${in.body[1].getId}", 456);
        this.assertExpression("${in.body[1].getName}", "ActiveMQ in Action");
    }

    public void testBodyOGNLListShorthand() throws Exception {
        ArrayList<OrderLine> lines = new ArrayList<OrderLine>();
        lines.add(new OrderLine(123, "Camel in Action"));
        lines.add(new OrderLine(456, "ActiveMQ in Action"));
        this.exchange.getIn().setBody(lines);
        this.assertExpression("${in.body[0].id}", 123);
        this.assertExpression("${in.body[0].name}", "Camel in Action");
        this.assertExpression("${in.body[1].id}", 456);
        this.assertExpression("${in.body[1].name}", "ActiveMQ in Action");
    }

    public void testBodyOGNLArray() throws Exception {
        OrderLine[] lines = new OrderLine[]{new OrderLine(123, "Camel in Action"), new OrderLine(456, "ActiveMQ in Action")};
        this.exchange.getIn().setBody((Object)lines);
        this.assertExpression("${in.body[0].getId}", 123);
        this.assertExpression("${in.body[0].getName}", "Camel in Action");
        this.assertExpression("${in.body[1].getId}", 456);
        this.assertExpression("${in.body[1].getName}", "ActiveMQ in Action");
    }

    public void testBodyOGNLArrayShorthand() throws Exception {
        OrderLine[] lines = new OrderLine[]{new OrderLine(123, "Camel in Action"), new OrderLine(456, "ActiveMQ in Action")};
        this.exchange.getIn().setBody((Object)lines);
        this.assertExpression("${in.body[0].id}", 123);
        this.assertExpression("${in.body[0].name}", "Camel in Action");
        this.assertExpression("${in.body[1].id}", 456);
        this.assertExpression("${in.body[1].name}", "ActiveMQ in Action");
    }

    public void testBodyOGNLOrderListOutOfBounds() throws Exception {
        Throwable cause;
        ArrayList<OrderLine> lines = new ArrayList<OrderLine>();
        lines.add(new OrderLine(123, "Camel in Action"));
        lines.add(new OrderLine(456, "ActiveMQ in Action"));
        Order order = new Order(lines);
        this.exchange.getIn().setBody((Object)order);
        try {
            this.assertExpression("${in.body.getLines[3].getId}", 123);
            SimpleTest.fail((String)"Should have thrown an exception");
        }
        catch (RuntimeBeanExpressionException e) {
            cause = SimpleTest.assertIsInstanceOf(IndexOutOfBoundsException.class, e.getCause());
            SimpleTest.assertTrue((boolean)cause.getMessage().startsWith("Index: 3, Size: 2 out of bounds with List from bean"));
        }
        try {
            this.assertExpression("${in.body.getLines[last-2].getId}", 123);
            SimpleTest.fail((String)"Should have thrown an exception");
        }
        catch (RuntimeBeanExpressionException e) {
            cause = SimpleTest.assertIsInstanceOf(IndexOutOfBoundsException.class, e.getCause());
            SimpleTest.assertTrue((boolean)cause.getMessage().startsWith("Index: -1, Size: 2 out of bounds with List from bean"));
        }
        try {
            this.assertExpression("${in.body.getLines[last - XXX].getId}", 123);
            SimpleTest.fail((String)"Should have thrown an exception");
        }
        catch (RuntimeBeanExpressionException e) {
            cause = SimpleTest.assertIsInstanceOf(ExpressionIllegalSyntaxException.class, e.getCause());
            SimpleTest.assertEquals((String)"last - XXX", (String)cause.getExpression());
        }
    }

    public void testBodyOGNLOrderListOutOfBoundsShorthand() throws Exception {
        Throwable cause;
        ArrayList<OrderLine> lines = new ArrayList<OrderLine>();
        lines.add(new OrderLine(123, "Camel in Action"));
        lines.add(new OrderLine(456, "ActiveMQ in Action"));
        Order order = new Order(lines);
        this.exchange.getIn().setBody((Object)order);
        try {
            this.assertExpression("${in.body.lines[3].id}", 123);
            SimpleTest.fail((String)"Should have thrown an exception");
        }
        catch (RuntimeBeanExpressionException e) {
            cause = SimpleTest.assertIsInstanceOf(IndexOutOfBoundsException.class, e.getCause());
            SimpleTest.assertTrue((boolean)cause.getMessage().startsWith("Index: 3, Size: 2 out of bounds with List from bean"));
        }
        try {
            this.assertExpression("${in.body.lines[last - 2].id}", 123);
            SimpleTest.fail((String)"Should have thrown an exception");
        }
        catch (RuntimeBeanExpressionException e) {
            cause = SimpleTest.assertIsInstanceOf(IndexOutOfBoundsException.class, e.getCause());
            SimpleTest.assertTrue((boolean)cause.getMessage().startsWith("Index: -1, Size: 2 out of bounds with List from bean"));
        }
        try {
            this.assertExpression("${in.body.lines[last - XXX].id}", 123);
            SimpleTest.fail((String)"Should have thrown an exception");
        }
        catch (RuntimeBeanExpressionException e) {
            cause = SimpleTest.assertIsInstanceOf(ExpressionIllegalSyntaxException.class, e.getCause());
            SimpleTest.assertEquals((String)"last - XXX", (String)cause.getExpression());
        }
    }

    public void testBodyOGNLOrderListOutOfBoundsWithNullSafe() throws Exception {
        ArrayList<OrderLine> lines = new ArrayList<OrderLine>();
        lines.add(new OrderLine(123, "Camel in Action"));
        lines.add(new OrderLine(456, "ActiveMQ in Action"));
        Order order = new Order(lines);
        this.exchange.getIn().setBody((Object)order);
        this.assertExpression("${in.body?.getLines[3].getId}", null);
    }

    public void testBodyOGNLOrderListOutOfBoundsWithNullSafeShorthand() throws Exception {
        ArrayList<OrderLine> lines = new ArrayList<OrderLine>();
        lines.add(new OrderLine(123, "Camel in Action"));
        lines.add(new OrderLine(456, "ActiveMQ in Action"));
        Order order = new Order(lines);
        this.exchange.getIn().setBody((Object)order);
        this.assertExpression("${in.body?.lines[3].id}", null);
    }

    public void testBodyOGNLOrderListNoMethodNameWithNullSafe() throws Exception {
        ArrayList<OrderLine> lines = new ArrayList<OrderLine>();
        lines.add(new OrderLine(123, "Camel in Action"));
        lines.add(new OrderLine(456, "ActiveMQ in Action"));
        Order order = new Order(lines);
        this.exchange.getIn().setBody((Object)order);
        try {
            this.assertExpression("${in.body.getLines[0]?.getRating}", "");
            SimpleTest.fail((String)"Should have thrown exception");
        }
        catch (RuntimeBeanExpressionException e) {
            MethodNotFoundException cause = SimpleTest.assertIsInstanceOf(MethodNotFoundException.class, e.getCause());
            SimpleTest.assertEquals((String)"getRating", (String)cause.getMethodName());
        }
    }

    public void testBodyOGNLOrderListNoMethodNameWithNullSafeShorthand() throws Exception {
        ArrayList<OrderLine> lines = new ArrayList<OrderLine>();
        lines.add(new OrderLine(123, "Camel in Action"));
        lines.add(new OrderLine(456, "ActiveMQ in Action"));
        Order order = new Order(lines);
        this.exchange.getIn().setBody((Object)order);
        try {
            this.assertExpression("${in.body.lines[0]?.rating}", "");
            SimpleTest.fail((String)"Should have thrown exception");
        }
        catch (RuntimeBeanExpressionException e) {
            MethodNotFoundException cause = SimpleTest.assertIsInstanceOf(MethodNotFoundException.class, e.getCause());
            SimpleTest.assertEquals((String)"rating", (String)cause.getMethodName());
        }
    }

    public void testBodyOGNLNullSafeToAvoidNPE() throws Exception {
        Animal tiger = new Animal("Tony the Tiger", 13);
        Animal camel = new Animal("Camel", 6);
        camel.setFriend(tiger);
        this.exchange.getIn().setBody((Object)camel);
        this.assertExpression("${in.body.getName}", "Camel");
        this.assertExpression("${in.body.getAge}", 6);
        this.assertExpression("${in.body.getFriend.getName}", "Tony the Tiger");
        this.assertExpression("${in.body.getFriend.getAge}", "13");
        this.assertExpression("${in.body.getFriend?.getFriend.getName}", null);
        try {
            this.assertExpression("${in.body.getFriend.getFriend.getName}", "");
            SimpleTest.fail((String)"Should have thrown exception");
        }
        catch (RuntimeBeanExpressionException e) {
            SimpleTest.assertEquals((String)"Failed to invoke method: .getFriend.getFriend.getName on org.apache.camel.language.simple.SimpleTest.Animal due last method returned null and therefore cannot continue to invoke method .getName on a null instance", (String)e.getMessage());
        }
    }

    public void testBodyOGNLNullSafeToAvoidNPEShorthand() throws Exception {
        Animal tiger = new Animal("Tony the Tiger", 13);
        Animal camel = new Animal("Camel", 6);
        camel.setFriend(tiger);
        this.exchange.getIn().setBody((Object)camel);
        this.assertExpression("${in.body.name}", "Camel");
        this.assertExpression("${in.body.age}", 6);
        this.assertExpression("${in.body.friend.getName}", "Tony the Tiger");
        this.assertExpression("${in.body.getFriend.age}", "13");
        this.assertExpression("${in.body.friend?.friend.name}", null);
        try {
            this.assertExpression("${in.body.friend.friend.name}", "");
            SimpleTest.fail((String)"Should have thrown exception");
        }
        catch (RuntimeBeanExpressionException e) {
            SimpleTest.assertEquals((String)"Failed to invoke method: .friend.friend.name on org.apache.camel.language.simple.SimpleTest.Animal due last method returned null and therefore cannot continue to invoke method .name on a null instance", (String)e.getMessage());
        }
    }

    public void testBodyOGNLReentrant() throws Exception {
        Animal camel = new Animal("Camel", 6);
        Animal tiger = new Animal("Tony the Tiger", 13);
        Animal elephant = new Animal("Big Ella", 48);
        camel.setFriend(tiger);
        tiger.setFriend(elephant);
        elephant.setFriend(camel);
        this.exchange.getIn().setBody((Object)camel);
        this.assertExpression("${body.getFriend.getFriend.getFriend.getName}", "Camel");
        this.assertExpression("${body.getFriend.getFriend.getFriend.getFriend.getName}", "Tony the Tiger");
        this.assertExpression("${body.getFriend.getFriend.getFriend.getFriend.getFriend.getName}", "Big Ella");
    }

    public void testBodyOGNLReentrantShorthand() throws Exception {
        Animal camel = new Animal("Camel", 6);
        Animal tiger = new Animal("Tony the Tiger", 13);
        Animal elephant = new Animal("Big Ella", 48);
        camel.setFriend(tiger);
        tiger.setFriend(elephant);
        elephant.setFriend(camel);
        this.exchange.getIn().setBody((Object)camel);
        this.assertExpression("${body.friend.friend.friend.name}", "Camel");
        this.assertExpression("${body.friend.friend.friend.friend.name}", "Tony the Tiger");
        this.assertExpression("${body.friend.friend.friend.friend.friend.name}", "Big Ella");
    }

    public void testBodyOGNLBoolean() throws Exception {
        Animal tiger = new Animal("Tony the Tiger", 13);
        this.exchange.getIn().setBody((Object)tiger);
        this.assertExpression("${body.isDangerous}", "true");
        this.assertExpression("${body.dangerous}", "true");
        Animal camel = new Animal("Camel", 6);
        this.exchange.getIn().setBody((Object)camel);
        this.assertExpression("${body.isDangerous}", "false");
        this.assertExpression("${body.dangerous}", "false");
    }

    public void testBodyOgnlOnString() throws Exception {
        this.exchange.getIn().setBody((Object)"Camel");
        this.assertExpression("${body.substring(2)}", "mel");
        this.assertExpression("${body.substring(2, 4)}", "me");
        this.assertExpression("${body.length()}", 5);
        this.assertExpression("${body.toUpperCase()}", "CAMEL");
        this.assertExpression("${body.toUpperCase()}", "CAMEL");
        this.assertExpression("${body.toUpperCase().substring(2)}", "MEL");
        this.assertExpression("${body.toLowerCase().length()}", 5);
    }

    public void testBodyOgnlOnStringWithOgnlParams() throws Exception {
        this.exchange.getIn().setBody((Object)"Camel");
        this.exchange.getIn().setHeader("max", (Object)4);
        this.exchange.getIn().setHeader("min", (Object)2);
        this.assertExpression("${body.substring(${header.min}, ${header.max})}", "me");
    }

    public void testHeaderOgnlOnStringWithOgnlParams() throws Exception {
        this.exchange.getIn().setBody(null);
        this.exchange.getIn().setHeader("name", (Object)"Camel");
        this.exchange.getIn().setHeader("max", (Object)4);
        this.exchange.getIn().setHeader("min", (Object)2);
        this.assertExpression("${header.name.substring(${header.min}, ${header.max})}", "me");
    }

    public void testCamelContextStartRoute() throws Exception {
        this.exchange.getIn().setBody(null);
        this.assertExpression("${camelContext.startRoute('foo')}", null);
    }

    public void testBodyOgnlReplace() throws Exception {
        this.exchange.getIn().setBody((Object)"Kamel is a cool Kamel");
        this.assertExpression("${body.replace(\"Kamel\", \"Camel\")}", "Camel is a cool Camel");
    }

    public void testBodyOgnlReplaceEscapedChar() throws Exception {
        this.exchange.getIn().setBody((Object)"foo$bar$baz");
        this.assertExpression("${body.replace('$', '-')}", "foo-bar-baz");
    }

    public void testBodyOgnlReplaceEscapedBackslashChar() throws Exception {
        this.exchange.getIn().setBody((Object)"foo\\bar\\baz");
        this.assertExpression("${body.replace('\\', '\\\\')}", "foo\\\\bar\\\\baz");
    }

    public void testBodyOgnlReplaceFirst() throws Exception {
        this.exchange.getIn().setBody((Object)"http:camel.apache.org");
        this.assertExpression("${body.replaceFirst('http:', 'http4:')}", "http4:camel.apache.org");
        this.assertExpression("${body.replaceFirst('http:', '')}", "camel.apache.org");
        this.assertExpression("${body.replaceFirst('http:', ' ')}", " camel.apache.org");
        this.assertExpression("${body.replaceFirst('http:',    ' ')}", " camel.apache.org");
        this.assertExpression("${body.replaceFirst('http:',' ')}", " camel.apache.org");
    }

    public void testBodyOgnlReplaceSingleQuoteInDouble() throws Exception {
        this.exchange.getIn().setBody((Object)"Hello O'Conner");
        this.assertExpression("${body.replace(\"O'C\", \"OC\")}", "Hello OConner");
        this.assertExpression("${body.replace(\"O'C\", \"O C\")}", "Hello O Conner");
        this.assertExpression("${body.replace(\"O'C\", \"O-C\")}", "Hello O-Conner");
        this.assertExpression("${body.replace(\"O'C\", \"O''C\")}", "Hello O''Conner");
        this.assertExpression("${body.replace(\"O'C\", \"O\n'C\")}", "Hello O\n'Conner");
    }

    public void testBodyOgnlSpaces() throws Exception {
        this.exchange.getIn().setBody((Object)"Hello World");
        this.assertExpression("${body.compareTo(Hello World)}", 0);
        this.assertExpression("${body.compareTo('Hello World')}", 0);
        this.assertExpression("${body.compareTo(${body})}", 0);
        this.assertExpression("${body.compareTo('foo')}", "Hello World".compareTo("foo"));
        this.assertExpression("${body.compareTo( 'Hello World' )}", 0);
        this.assertExpression("${body.compareTo( ${body} )}", 0);
        this.assertExpression("${body.compareTo( 'foo' )}", "Hello World".compareTo("foo"));
    }

    public void testClassSimpleName() throws Exception {
        Animal tiger = new Animal("Tony the Tiger", 13);
        this.exchange.getIn().setBody((Object)tiger);
        this.assertExpression("${body.getClass().getSimpleName()}", "Animal");
        this.assertExpression("${body.getClass.getSimpleName}", "Animal");
        this.assertExpression("${body.class.simpleName}", "Animal");
    }

    public void testExceptionClassSimpleName() throws Exception {
        Animal tiger = new Animal("Tony the Tiger", 13);
        this.exchange.getIn().setBody((Object)tiger);
        IllegalArgumentException cause = new IllegalArgumentException("Forced");
        this.exchange.setException((Throwable)cause);
        this.assertExpression("${exception.getClass().getSimpleName()}", "IllegalArgumentException");
        this.assertExpression("${exception.getClass.getSimpleName}", "IllegalArgumentException");
        this.assertExpression("${exception.class.simpleName}", "IllegalArgumentException");
    }

    public void testSlashBeforeHeader() throws Exception {
        this.assertExpression("foo/${header.foo}", "foo/abc");
        this.assertExpression("foo\\${header.foo}", "foo\\abc");
    }

    public void testJSonLike() throws Exception {
        this.exchange.getIn().setBody((Object)"Something");
        this.assertExpression("{\n\"data\": \"${body}\"\n}", "{\n\"data\": \"Something\"\n}");
    }

    public void testFunctionEnds() throws Exception {
        this.exchange.getIn().setBody((Object)"Something");
        this.assertExpression("{{", "{{");
        this.assertExpression("}}", "}}");
        this.assertExpression("{{}}", "{{}}");
        this.assertExpression("{{foo}}", "{{foo}}");
        this.assertExpression("{{${body}}}", "{{Something}}");
        this.assertExpression("{{${body}-${body}}}", "{{Something-Something}}");
    }

    public void testEscape() throws Exception {
        this.exchange.getIn().setBody((Object)"Something");
        this.assertExpression("\\foo", "\\foo");
        this.assertExpression("\\n${body}", "\nSomething");
        this.assertExpression("\\t${body}", "\tSomething");
        this.assertExpression("\\r${body}", "\rSomething");
        this.assertExpression("\\n\\r${body}", "\n\rSomething");
        this.assertExpression("\\n${body}\\n", "\nSomething\n");
        this.assertExpression("\\t${body}\\t", "\tSomething\t");
        this.assertExpression("\\r${body}\\r", "\rSomething\r");
        this.assertExpression("\\n\\r${body}\\n\\r", "\n\rSomething\n\r");
        this.assertExpression("$${body}", "$Something");
    }

    public void testCamelContextOGNL() throws Exception {
        this.assertExpression("${camelContext.getName()}", this.context.getName());
        this.assertExpression("${camelContext.version}", this.context.getVersion());
    }

    public void testTypeConstant() throws Exception {
        this.assertExpression("${type:org.apache.camel.Exchange.FILE_NAME}", "CamelFileName");
        this.assertExpression("${type:org.apache.camel.ExchangePattern.InOut}", ExchangePattern.InOut);
        this.assertExpression("${type:org.apache.camel.ExchangePattern.}", null);
        this.assertExpression("${type:org.apache.camel.ExchangePattern.UNKNOWN}", null);
    }

    public void testTypeConstantInnerClass() throws Exception {
        this.assertExpression("${type:org.apache.camel.language.simple.Constants$MyInnerStuff.FOO}", 123);
        this.assertExpression("${type:org.apache.camel.language.simple.Constants.BAR}", 456);
    }

    public void testStringArrayLength() throws Exception {
        this.exchange.getIn().setBody((Object)new String[]{"foo", "bar"});
        this.assertExpression("${body[0]}", "foo");
        this.assertExpression("${body[1]}", "bar");
        this.assertExpression("${body.length}", 2);
        this.exchange.getIn().setBody((Object)new String[]{"foo", "bar", "beer"});
        this.assertExpression("${body.length}", 3);
    }

    public void testByteArrayLength() throws Exception {
        this.exchange.getIn().setBody((Object)new byte[]{65, 66, 67});
        this.assertExpression("${body[0]}", 65);
        this.assertExpression("${body[1]}", 66);
        this.assertExpression("${body[2]}", 67);
        this.assertExpression("${body.length}", 3);
    }

    public void testSimpleMapBoolean() throws Exception {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        this.exchange.getIn().setBody(map);
        map.put("isCredit", true);
        this.assertPredicate("${body[isCredit]} == true", true);
        this.assertPredicate("${body[isCredit]} == false", false);
        this.assertPredicate("${body['isCredit']} == true", true);
        this.assertPredicate("${body['isCredit']} == false", false);
        this.assertPredicate("${body['IsCredit']} == true", false);
        map.put("isCredit", false);
        this.assertPredicate("${body[isCredit]} == true", false);
        this.assertPredicate("${body[isCredit]} == false", true);
        this.assertPredicate("${body['isCredit']} == true", false);
        this.assertPredicate("${body['isCredit']} == false", true);
    }

    public void testSimpleRegexp() throws Exception {
        this.exchange.getIn().setBody((Object)"12345678");
        this.assertPredicate("${body} regex '\\d+'", true);
        this.assertPredicate("${body} regex '\\w{1,4}'", false);
        this.exchange.getIn().setBody((Object)"tel:+97444549697");
        this.assertPredicate("${body} regex '^(tel:\\+)(974)(44)(\\d+)|^(974)(44)(\\d+)'", true);
        this.exchange.getIn().setBody((Object)"97444549697");
        this.assertPredicate("${body} regex '^(tel:\\+)(974)(44)(\\d+)|^(974)(44)(\\d+)'", true);
        this.exchange.getIn().setBody((Object)"tel:+87444549697");
        this.assertPredicate("${body} regex '^(tel:\\+)(974)(44)(\\d+)|^(974)(44)(\\d+)'", false);
        this.exchange.getIn().setBody((Object)"87444549697");
        this.assertPredicate("${body} regex '^(tel:\\+)(974)(44)(\\d+)|^(974)(44)(\\d+)'", false);
    }

    public void testCollateEven() throws Exception {
        ArrayList<String> data = new ArrayList<String>();
        data.add("A");
        data.add("B");
        data.add("C");
        data.add("D");
        data.add("E");
        data.add("F");
        this.exchange.getIn().setBody(data);
        Iterator it = (Iterator)this.evaluateExpression("${collate(3)}", null);
        List chunk = (List)it.next();
        List chunk2 = (List)it.next();
        SimpleTest.assertFalse((boolean)it.hasNext());
        SimpleTest.assertEquals((int)3, (int)chunk.size());
        SimpleTest.assertEquals((int)3, (int)chunk2.size());
        SimpleTest.assertEquals((Object)"A", chunk.get(0));
        SimpleTest.assertEquals((Object)"B", chunk.get(1));
        SimpleTest.assertEquals((Object)"C", chunk.get(2));
        SimpleTest.assertEquals((Object)"D", chunk2.get(0));
        SimpleTest.assertEquals((Object)"E", chunk2.get(1));
        SimpleTest.assertEquals((Object)"F", chunk2.get(2));
    }

    public void testCollateOdd() throws Exception {
        ArrayList<String> data = new ArrayList<String>();
        data.add("A");
        data.add("B");
        data.add("C");
        data.add("D");
        data.add("E");
        data.add("F");
        data.add("G");
        this.exchange.getIn().setBody(data);
        Iterator it = (Iterator)this.evaluateExpression("${collate(3)}", null);
        List chunk = (List)it.next();
        List chunk2 = (List)it.next();
        List chunk3 = (List)it.next();
        SimpleTest.assertFalse((boolean)it.hasNext());
        SimpleTest.assertEquals((int)3, (int)chunk.size());
        SimpleTest.assertEquals((int)3, (int)chunk2.size());
        SimpleTest.assertEquals((int)1, (int)chunk3.size());
        SimpleTest.assertEquals((Object)"A", chunk.get(0));
        SimpleTest.assertEquals((Object)"B", chunk.get(1));
        SimpleTest.assertEquals((Object)"C", chunk.get(2));
        SimpleTest.assertEquals((Object)"D", chunk2.get(0));
        SimpleTest.assertEquals((Object)"E", chunk2.get(1));
        SimpleTest.assertEquals((Object)"F", chunk2.get(2));
        SimpleTest.assertEquals((Object)"G", chunk3.get(0));
    }

    public void testRandomExpression() throws Exception {
        Expression expression;
        int min = 1;
        int max = 10;
        int iterations = 30;
        int i = 0;
        for (i = 0; i < iterations; ++i) {
            expression = SimpleLanguage.simple((String)"random(1,10)", Integer.class);
            SimpleTest.assertTrue((min <= (Integer)expression.evaluate(this.exchange, Integer.class) && (Integer)expression.evaluate(this.exchange, Integer.class) < max ? 1 : 0) != 0);
        }
        for (i = 0; i < iterations; ++i) {
            expression = SimpleLanguage.simple((String)"random(10)", Integer.class);
            SimpleTest.assertTrue((0 <= (Integer)expression.evaluate(this.exchange, Integer.class) && (Integer)expression.evaluate(this.exchange, Integer.class) < max ? 1 : 0) != 0);
        }
        expression = SimpleLanguage.simple((String)"random(1, 10)", Integer.class);
        SimpleTest.assertTrue((min <= (Integer)expression.evaluate(this.exchange, Integer.class) && (Integer)expression.evaluate(this.exchange, Integer.class) < max ? 1 : 0) != 0);
        Expression expression1 = SimpleLanguage.simple((String)"random( 10)", Integer.class);
        SimpleTest.assertTrue((0 <= (Integer)expression1.evaluate(this.exchange, Integer.class) && (Integer)expression1.evaluate(this.exchange, Integer.class) < max ? 1 : 0) != 0);
        try {
            this.assertExpression("random(10,21,30)", null);
            SimpleTest.fail((String)"Should have thrown exception");
        }
        catch (SimpleParserException e) {
            SimpleTest.assertEquals((String)"Valid syntax: ${random(min,max)} or ${random(max)} was: random(10,21,30)", (String)e.getMessage());
        }
        try {
            this.assertExpression("random()", null);
            SimpleTest.fail((String)"Should have thrown exception");
        }
        catch (SimpleParserException e) {
            SimpleTest.assertEquals((String)"Valid syntax: ${random(min,max)} or ${random(max)} was: random()", (String)e.getMessage());
        }
    }

    public void testListRemoveByInstance() throws Exception {
        ArrayList<String> data = new ArrayList<String>();
        data.add("A");
        data.add("B");
        this.exchange.getIn().setBody(data);
        SimpleTest.assertEquals((int)2, (int)data.size());
        Expression expression = SimpleLanguage.simple((String)"${body.remove('A')}");
        expression.evaluate(this.exchange, Object.class);
        SimpleTest.assertEquals((int)1, (int)data.size());
        SimpleTest.assertEquals((Object)"B", data.get(0));
    }

    public void testListRemoveIndex() throws Exception {
        ArrayList<String> data = new ArrayList<String>();
        data.add("A");
        data.add("B");
        this.exchange.getIn().setBody(data);
        SimpleTest.assertEquals((int)2, (int)data.size());
        Expression expression = SimpleLanguage.simple((String)"${body.remove(0)}");
        expression.evaluate(this.exchange, Object.class);
        SimpleTest.assertEquals((int)1, (int)data.size());
        SimpleTest.assertEquals((Object)"B", data.get(0));
    }

    @Override
    protected String getLanguageName() {
        return "simple";
    }

    protected void assertExpressionResultInstanceOf(String expressionText, Class<?> expectedType) {
        Language language = this.assertResolveLanguage(this.getLanguageName());
        Expression expression = language.createExpression(expressionText);
        SimpleTest.assertNotNull((String)"Cannot assert type when no type is provided", expectedType);
        SimpleTest.assertNotNull((String)("No Expression could be created for text: " + expressionText + " language: " + language), (Object)expression);
        Object answer = expression.evaluate(this.exchange, Object.class);
        SimpleTest.assertIsInstanceOf(expectedType, answer);
    }

    public static class MyClass {
        public Object[] getMyArray() {
            return new Object[]{"Hallo", "World", "!"};
        }
    }

    public static final class OrderLine {
        private int id;
        private String name;

        public OrderLine(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }

    public static final class Order {
        private List<OrderLine> lines;

        public Order(List<OrderLine> lines) {
            this.lines = lines;
        }

        public List<OrderLine> getLines() {
            return this.lines;
        }

        public void setLines(List<OrderLine> lines) {
            this.lines = lines;
        }
    }

    public static final class Animal {
        private String name;
        private int age;
        private Animal friend;

        private Animal(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public String getName() {
            return this.name;
        }

        public int getAge() {
            return this.age;
        }

        public Animal getFriend() {
            return this.friend;
        }

        public void setFriend(Animal friend) {
            this.friend = friend;
        }

        public boolean isDangerous() {
            return this.name.contains("Tiger");
        }

        public String toString() {
            return this.name;
        }
    }
}

