/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.camel.ExchangeTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.language.simple.SimplePredicateParser;

public class SimpleParserPredicateTest
extends ExchangeTestSupport {
    public void testSimpleBooleanValue() throws Exception {
        this.exchange.getIn().setBody((Object)"foo");
        SimplePredicateParser parser = new SimplePredicateParser("true", true);
        Predicate pre = parser.parsePredicate();
        SimpleParserPredicateTest.assertTrue((boolean)pre.matches(this.exchange));
        parser = new SimplePredicateParser("false", true);
        pre = parser.parsePredicate();
        SimpleParserPredicateTest.assertFalse((boolean)pre.matches(this.exchange));
    }

    public void testSimpleEq() throws Exception {
        this.exchange.getIn().setBody((Object)"foo");
        SimplePredicateParser parser = new SimplePredicateParser("${body} == 'foo'", true);
        Predicate pre = parser.parsePredicate();
        SimpleParserPredicateTest.assertTrue((boolean)pre.matches(this.exchange));
    }

    public void testSimpleEqNumeric() throws Exception {
        this.exchange.getIn().setBody((Object)123);
        SimplePredicateParser parser = new SimplePredicateParser("${body} == 123", true);
        Predicate pre = parser.parsePredicate();
        SimpleParserPredicateTest.assertTrue((String)"Should match", (boolean)pre.matches(this.exchange));
    }

    public void testSimpleEqFunctionFunction() throws Exception {
        this.exchange.getIn().setBody((Object)122);
        this.exchange.getIn().setHeader("val", (Object)122);
        SimplePredicateParser parser = new SimplePredicateParser("${body} == ${header.val}", true);
        Predicate pre = parser.parsePredicate();
        SimpleParserPredicateTest.assertTrue((String)"Should match", (boolean)pre.matches(this.exchange));
    }

    public void testSimpleEqFunctionNumeric() throws Exception {
        this.exchange.getIn().setBody((Object)122);
        SimplePredicateParser parser = new SimplePredicateParser("${body} == 122", true);
        Predicate pre = parser.parsePredicate();
        SimpleParserPredicateTest.assertTrue((String)"Should match", (boolean)pre.matches(this.exchange));
    }

    public void testSimpleGtFunctionNumeric() throws Exception {
        this.exchange.getIn().setBody((Object)122);
        SimplePredicateParser parser = new SimplePredicateParser("${body} > 120", true);
        Predicate pre = parser.parsePredicate();
        SimpleParserPredicateTest.assertTrue((String)"Should match", (boolean)pre.matches(this.exchange));
    }

    public void testSimpleUnaryInc() throws Exception {
        this.exchange.getIn().setBody((Object)122);
        SimplePredicateParser parser = new SimplePredicateParser("${body}++ == 123", true);
        Predicate pre = parser.parsePredicate();
        SimpleParserPredicateTest.assertTrue((String)"Should match", (boolean)pre.matches(this.exchange));
    }

    public void testSimpleUnaryDec() throws Exception {
        this.exchange.getIn().setBody((Object)122);
        SimplePredicateParser parser = new SimplePredicateParser("${body}-- == 121", true);
        Predicate pre = parser.parsePredicate();
        SimpleParserPredicateTest.assertTrue((String)"Should match", (boolean)pre.matches(this.exchange));
    }

    public void testSimpleEqFunctionBoolean() throws Exception {
        this.exchange.getIn().setBody((Object)"Hello");
        this.exchange.getIn().setHeader("high", (Object)true);
        SimplePredicateParser parser = new SimplePredicateParser("${header.high} == true", true);
        Predicate pre = parser.parsePredicate();
        SimpleParserPredicateTest.assertTrue((String)"Should match", (boolean)pre.matches(this.exchange));
    }

    public void testSimpleEqFunctionBooleanSpaces() throws Exception {
        this.exchange.getIn().setBody((Object)"Hello");
        this.exchange.getIn().setHeader("high", (Object)true);
        SimplePredicateParser parser = new SimplePredicateParser("${header.high}   ==     true", true);
        Predicate pre = parser.parsePredicate();
        SimpleParserPredicateTest.assertTrue((String)"Should match", (boolean)pre.matches(this.exchange));
    }

    public void testSimpleLogicalAnd() throws Exception {
        this.exchange.getIn().setBody((Object)"Hello");
        this.exchange.getIn().setHeader("high", (Object)true);
        this.exchange.getIn().setHeader("foo", (Object)123);
        SimplePredicateParser parser = new SimplePredicateParser("${header.high} == true && ${header.foo} == 123", true);
        Predicate pre = parser.parsePredicate();
        SimpleParserPredicateTest.assertTrue((String)"Should match", (boolean)pre.matches(this.exchange));
    }

    public void testSimpleLogicalOr() throws Exception {
        this.exchange.getIn().setBody((Object)"Hello");
        this.exchange.getIn().setHeader("high", (Object)true);
        this.exchange.getIn().setHeader("foo", (Object)123);
        SimplePredicateParser parser = new SimplePredicateParser("${header.high} == false || ${header.foo} == 123", true);
        Predicate pre = parser.parsePredicate();
        SimpleParserPredicateTest.assertTrue((String)"Should match", (boolean)pre.matches(this.exchange));
    }

    public void testSimpleLogicalAndAnd() throws Exception {
        this.exchange.getIn().setBody((Object)"Hello");
        this.exchange.getIn().setHeader("high", (Object)true);
        this.exchange.getIn().setHeader("foo", (Object)123);
        this.exchange.getIn().setHeader("bar", (Object)"beer");
        SimplePredicateParser parser = new SimplePredicateParser("${header.high} == true && ${header.foo} == 123 && ${header.bar} == 'beer'", true);
        Predicate pre = parser.parsePredicate();
        SimpleParserPredicateTest.assertTrue((String)"Should match", (boolean)pre.matches(this.exchange));
    }

    public void testSimpleManyAndLogical() throws Exception {
        this.exchange.getIn().setBody((Object)"Hello");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            this.exchange.getIn().setHeader("foo" + i, (Object)i);
            sb.append("${header.foo").append(i).append("} == ").append(i);
            if (i >= 9) continue;
            sb.append(" && ");
        }
        SimplePredicateParser parser = new SimplePredicateParser(sb.toString(), true);
        Predicate pre = parser.parsePredicate();
        SimpleParserPredicateTest.assertTrue((String)"Should match", (boolean)pre.matches(this.exchange));
    }

    public void testSimpleManyOrLogical() throws Exception {
        this.exchange.getIn().setBody((Object)"Hello");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            sb.append("${header.foo").append(i).append("} == ").append(i);
            if (i >= 9) continue;
            sb.append(" || ");
        }
        sb.append(" || ${body} == 'Hello'");
        SimplePredicateParser parser = new SimplePredicateParser(sb.toString(), true);
        Predicate pre = parser.parsePredicate();
        SimpleParserPredicateTest.assertTrue((String)"Should match", (boolean)pre.matches(this.exchange));
    }

    public void testSimpleExpressionPredicate() throws Exception {
        this.exchange.getIn().setBody((Object)"Hello");
        this.exchange.getIn().setHeader("number", (Object)"1234");
        SimplePredicateParser parser = new SimplePredicateParser("${in.header.number} regex '\\d{4}'", true);
        Predicate pre = parser.parsePredicate();
        SimpleParserPredicateTest.assertTrue((String)"Should match", (boolean)pre.matches(this.exchange));
    }

    public void testSimpleMap() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "123");
        map.put("foo bar", "456");
        this.exchange.getIn().setBody(map);
        SimplePredicateParser parser = new SimplePredicateParser("${body[foo]} == 123", true);
        Predicate pre = parser.parsePredicate();
        SimpleParserPredicateTest.assertTrue((String)"Should match", (boolean)pre.matches(this.exchange));
        parser = new SimplePredicateParser("${body['foo bar']} == 456", true);
        pre = parser.parsePredicate();
        SimpleParserPredicateTest.assertTrue((String)"Should match", (boolean)pre.matches(this.exchange));
        parser = new SimplePredicateParser("${body[foo bar]} == 456", true);
        pre = parser.parsePredicate();
        SimpleParserPredicateTest.assertTrue((String)"Should match", (boolean)pre.matches(this.exchange));
        parser = new SimplePredicateParser("${body[unknown]} == 456", true);
        pre = parser.parsePredicate();
        SimpleParserPredicateTest.assertFalse((String)"Should not match", (boolean)pre.matches(this.exchange));
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        ArrayList<String> list = new ArrayList<String>();
        list.add("foo");
        list.add("bar");
        jndi.bind("myList", list);
        return jndi;
    }

    public void testSimpleIn() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "foo");
        map.put("key2", "bar");
        map.put("key3", "none");
        this.exchange.getIn().setBody(map);
        SimplePredicateParser parser = new SimplePredicateParser("${body[key]} in ${ref:myList}", true);
        Predicate pre = parser.parsePredicate();
        SimpleParserPredicateTest.assertTrue((String)"Should match", (boolean)pre.matches(this.exchange));
        parser = new SimplePredicateParser("${body[key2]} in ${ref:myList}", true);
        pre = parser.parsePredicate();
        SimpleParserPredicateTest.assertTrue((String)"Should match", (boolean)pre.matches(this.exchange));
        parser = new SimplePredicateParser("${body[key3]} in ${ref:myList}", true);
        pre = parser.parsePredicate();
        SimpleParserPredicateTest.assertFalse((String)"Should not match", (boolean)pre.matches(this.exchange));
    }
}

