/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import org.apache.camel.Exchange;
import org.apache.camel.LanguageTestSupport;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.language.simple.types.SimpleIllegalSyntaxException;

public class SimpleOperatorTest
extends LanguageTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("generator", (Object)new MyFileNameGenerator());
        return jndi;
    }

    public void testValueWithSpace() throws Exception {
        this.exchange.getIn().setBody((Object)"Hello Big World");
        this.assertPredicate("${in.body} == 'Hello Big World'", true);
    }

    public void testNullValue() throws Exception {
        this.exchange.getIn().setBody((Object)"Value");
        this.assertPredicate("${in.body} != null", true);
        this.assertPredicate("${body} == null", false);
        this.exchange.getIn().setBody(null);
        this.assertPredicate("${in.body} == null", true);
        this.assertPredicate("${body} != null", false);
    }

    public void testEmptyValue() throws Exception {
        this.exchange.getIn().setBody((Object)"");
        this.assertPredicate("${in.body} == null", false);
        this.assertPredicate("${body} == null", false);
        this.exchange.getIn().setBody((Object)"");
        this.assertPredicate("${in.body} == ''", true);
        this.assertPredicate("${body} == \"\"", true);
        this.exchange.getIn().setBody((Object)" ");
        this.assertPredicate("${in.body} == ''", false);
        this.assertPredicate("${body} == \"\"", false);
        this.exchange.getIn().setBody((Object)"Value");
        this.assertPredicate("${in.body} == ''", false);
        this.assertPredicate("${body} == \"\"", false);
    }

    public void testAnd() throws Exception {
        this.assertPredicate("${in.header.foo} == 'abc' && ${in.header.bar} == 123", true);
        this.assertPredicate("${in.header.foo} == 'abc' && ${in.header.bar} == 444", false);
        this.assertPredicate("${in.header.foo} == 'def' && ${in.header.bar} == 123", false);
        this.assertPredicate("${in.header.foo} == 'def' && ${in.header.bar} == 444", false);
        this.assertPredicate("${in.header.foo} == 'abc' && ${in.header.bar} > 100", true);
        this.assertPredicate("${in.header.foo} == 'abc' && ${in.header.bar} < 200", true);
    }

    public void testTwoAnd() throws Exception {
        this.exchange.getIn().setBody((Object)"Hello World");
        this.assertPredicate("${in.header.foo} == 'abc' && ${in.header.bar} == 123 && ${body} == 'Hello World'", true);
        this.assertPredicate("${in.header.foo} == 'abc' && ${in.header.bar} == 123 && ${body} == 'Bye World'", false);
    }

    public void testThreeAnd() throws Exception {
        this.exchange.getIn().setBody((Object)"Hello World");
        this.assertPredicate("${in.header.foo} == 'abc' && ${in.header.bar} == 123 && ${body} == 'Hello World' && ${in.header.xx} == null", true);
    }

    public void testTwoOr() throws Exception {
        this.exchange.getIn().setBody((Object)"Hello World");
        this.assertPredicate("${in.header.foo} == 'abc' || ${in.header.bar} == 44 || ${body} == 'Bye World'", true);
        this.assertPredicate("${in.header.foo} == 'xxx' || ${in.header.bar} == 44 || ${body} == 'Bye World'", false);
        this.assertPredicate("${in.header.foo} == 'xxx' || ${in.header.bar} == 44 || ${body} == 'Hello World'", true);
        this.assertPredicate("${in.header.foo} == 'xxx' || ${in.header.bar} == 123 || ${body} == 'Bye World'", true);
    }

    public void testThreeOr() throws Exception {
        this.exchange.getIn().setBody((Object)"Hello World");
        this.assertPredicate("${in.header.foo} == 'xxx' || ${in.header.bar} == 44 || ${body} == 'Bye Moon' || ${body} contains 'World'", true);
        this.assertPredicate("${in.header.foo} == 'xxx' || ${in.header.bar} == 44 || ${body} == 'Bye Moon' || ${body} contains 'Moon'", false);
        this.assertPredicate("${in.header.foo} == 'abc' || ${in.header.bar} == 44 || ${body} == 'Bye Moon' || ${body} contains 'Moon'", true);
        this.assertPredicate("${in.header.foo} == 'xxx' || ${in.header.bar} == 123 || ${body} == 'Bye Moon' || ${body} contains 'Moon'", true);
        this.assertPredicate("${in.header.foo} == 'xxx' || ${in.header.bar} == 44 || ${body} == 'Hello World' || ${body} contains 'Moon'", true);
    }

    public void testAndWithQuotation() throws Exception {
        this.assertPredicate("${in.header.foo} == 'abc' && ${in.header.bar} == '123'", true);
        this.assertPredicate("${in.header.foo} == 'abc' && ${in.header.bar} == '444'", false);
        this.assertPredicate("${in.header.foo} == 'def' && ${in.header.bar} == '123'", false);
        this.assertPredicate("${in.header.foo} == 'def' && ${in.header.bar} == '444'", false);
        this.assertPredicate("${in.header.foo} == 'abc' && ${in.header.bar} > '100'", true);
        this.assertPredicate("${in.header.foo} == 'abc' && ${in.header.bar} < '200'", true);
    }

    public void testOr() throws Exception {
        this.assertPredicate("${in.header.foo} == 'abc' || ${in.header.bar} == 123", true);
        this.assertPredicate("${in.header.foo} == 'abc' || ${in.header.bar} == 444", true);
        this.assertPredicate("${in.header.foo} == 'def' || ${in.header.bar} == 123", true);
        this.assertPredicate("${in.header.foo} == 'def' || ${in.header.bar} == 444", false);
        this.assertPredicate("${in.header.foo} == 'abc' || ${in.header.bar} < 100", true);
        this.assertPredicate("${in.header.foo} == 'abc' || ${in.header.bar} < 200", true);
        this.assertPredicate("${in.header.foo} == 'def' || ${in.header.bar} < 200", true);
        this.assertPredicate("${in.header.foo} == 'def' || ${in.header.bar} < 100", false);
    }

    public void testOrWithQuotation() throws Exception {
        this.assertPredicate("${in.header.foo} == 'abc' || ${in.header.bar} == '123'", true);
        this.assertPredicate("${in.header.foo} == 'abc' || ${in.header.bar} == '444'", true);
        this.assertPredicate("${in.header.foo} == 'def' || ${in.header.bar} == '123'", true);
        this.assertPredicate("${in.header.foo} == 'def' || ${in.header.bar} == '444'", false);
        this.assertPredicate("${in.header.foo} == 'abc' || ${in.header.bar} < '100'", true);
        this.assertPredicate("${in.header.foo} == 'abc' || ${in.header.bar} < '200'", true);
        this.assertPredicate("${in.header.foo} == 'def' || ${in.header.bar} < '200'", true);
        this.assertPredicate("${in.header.foo} == 'def' || ${in.header.bar} < '100'", false);
    }

    public void testEqualOperator() throws Exception {
        this.assertPredicate("${in.header.foo} == 'abc'", true);
        this.assertPredicate("${in.header.foo} == 'def'", false);
        this.assertPredicate("${in.header.foo} == '1'", false);
        this.assertPredicate("${in.header.bar} == '123'", true);
        this.assertPredicate("${in.header.bar} == 123", true);
        this.assertPredicate("${in.header.bar} == '444'", false);
        this.assertPredicate("${in.header.bar} == 444", false);
        this.assertPredicate("${in.header.bar} == '1'", false);
    }

    public void testEqualIgnoreOperator() throws Exception {
        this.assertPredicate("${in.header.foo} =~ 'abc'", true);
        this.assertPredicate("${in.header.foo} =~ 'ABC'", true);
        this.assertPredicate("${in.header.foo} =~ 'Abc'", true);
        this.assertPredicate("${in.header.foo} =~ 'Def'", false);
        this.assertPredicate("${in.header.foo} =~ '1'", false);
        this.assertPredicate("${in.header.bar} =~ '123'", true);
        this.assertPredicate("${in.header.bar} =~ 123", true);
        this.assertPredicate("${in.header.bar} =~ '444'", false);
        this.assertPredicate("${in.header.bar} =~ 444", false);
        this.assertPredicate("${in.header.bar} =~ '1'", false);
    }

    public void testNotEqualOperator() throws Exception {
        this.assertPredicate("${in.header.foo} != 'abc'", false);
        this.assertPredicate("${in.header.foo} != 'def'", true);
        this.assertPredicate("${in.header.foo} != '1'", true);
        this.assertPredicate("${in.header.bar} != '123'", false);
        this.assertPredicate("${in.header.bar} != 123", false);
        this.assertPredicate("${in.header.bar} != '444'", true);
        this.assertPredicate("${in.header.bar} != 444", true);
        this.assertPredicate("${in.header.bar} != '1'", true);
    }

    public void testFloatingNumber() throws Exception {
        this.exchange.getIn().setBody((Object)"0.02");
        this.assertPredicate("${body} > 0", true);
        this.assertPredicate("${body} < 0", false);
        this.assertPredicate("${body} > 0.00", true);
        this.assertPredicate("${body} < 0.00", false);
        this.assertPredicate("${body} > 0.01", true);
        this.assertPredicate("${body} < 0.01", false);
        this.assertPredicate("${body} > 0.02", false);
        this.assertPredicate("${body} < 0.02", false);
        this.assertPredicate("${body} == 0.02", true);
    }

    public void testGreaterThanOperator() throws Exception {
        this.assertPredicate("${in.header.foo} > 'aaa'", true);
        this.assertPredicate("${in.header.foo} > 'def'", false);
        this.assertPredicate("${in.header.bar} > '100'", true);
        this.assertPredicate("${in.header.bar} > 100", true);
        this.assertPredicate("${in.header.bar} > '123'", false);
        this.assertPredicate("${in.header.bar} > 123", false);
        this.assertPredicate("${in.header.bar} > '200'", false);
    }

    public void testGreaterThanStringToInt() throws Exception {
        this.exchange.getIn().setHeader("num", (Object)"70");
        this.assertPredicate("${in.header.num} > 100", false);
        this.assertPredicate("${in.header.num} > 100", false);
        this.assertPredicate("${in.header.num} > 80", false);
        this.assertPredicate("${in.header.num} > 800", false);
        this.assertPredicate("${in.header.num} > 1", true);
        this.assertPredicate("${in.header.num} > 8", true);
        this.assertPredicate("${in.header.num} > 48", true);
        this.assertPredicate("${in.header.num} > 69", true);
        this.assertPredicate("${in.header.num} > 71", false);
        this.assertPredicate("${in.header.num} > 88", false);
        this.assertPredicate("${in.header.num} > 777", false);
    }

    public void testLessThanStringToInt() throws Exception {
        this.exchange.getIn().setHeader("num", (Object)"70");
        this.assertPredicate("${in.header.num} < 100", true);
        this.assertPredicate("${in.header.num} < 100", true);
        this.assertPredicate("${in.header.num} < 80", true);
        this.assertPredicate("${in.header.num} < 800", true);
        this.assertPredicate("${in.header.num} < 1", false);
        this.assertPredicate("${in.header.num} < 8", false);
        this.assertPredicate("${in.header.num} < 48", false);
        this.assertPredicate("${in.header.num} < 69", false);
        this.assertPredicate("${in.header.num} < 71", true);
        this.assertPredicate("${in.header.num} < 88", true);
        this.assertPredicate("${in.header.num} < 777", true);
    }

    public void testGreaterThanOrEqualOperator() throws Exception {
        this.assertPredicate("${in.header.foo} >= 'aaa'", true);
        this.assertPredicate("${in.header.foo} >= 'abc'", true);
        this.assertPredicate("${in.header.foo} >= 'def'", false);
        this.assertPredicate("${in.header.bar} >= '100'", true);
        this.assertPredicate("${in.header.bar} >= 100", true);
        this.assertPredicate("${in.header.bar} >= '123'", true);
        this.assertPredicate("${in.header.bar} >= 123", true);
        this.assertPredicate("${in.header.bar} >= '200'", false);
    }

    public void testLessThanOperator() throws Exception {
        this.assertPredicate("${in.header.foo} < 'aaa'", false);
        this.assertPredicate("${in.header.foo} < 'def'", true);
        this.assertPredicate("${in.header.bar} < '100'", false);
        this.assertPredicate("${in.header.bar} < 100", false);
        this.assertPredicate("${in.header.bar} < '123'", false);
        this.assertPredicate("${in.header.bar} < 123", false);
        this.assertPredicate("${in.header.bar} < '200'", true);
    }

    public void testLessThanOrEqualOperator() throws Exception {
        this.assertPredicate("${in.header.foo} <= 'aaa'", false);
        this.assertPredicate("${in.header.foo} <= 'abc'", true);
        this.assertPredicate("${in.header.foo} <= 'def'", true);
        this.assertPredicate("${in.header.bar} <= '100'", false);
        this.assertPredicate("${in.header.bar} <= 100", false);
        this.assertPredicate("${in.header.bar} <= '123'", true);
        this.assertPredicate("${in.header.bar} <= 123", true);
        this.assertPredicate("${in.header.bar} <= '200'", true);
    }

    public void testIsNull() throws Exception {
        this.assertPredicate("${in.header.foo} == null", false);
        this.assertPredicate("${in.header.none} == null", true);
    }

    public void testIsNotNull() throws Exception {
        this.assertPredicate("${in.header.foo} != null", true);
        this.assertPredicate("${in.header.none} != null", false);
    }

    public void testRightOperatorIsSimpleLanguage() throws Exception {
        this.assertPredicate("${in.header.foo} == ${in.header.foo}", true);
        this.assertPredicate("${in.header.foo} == ${in.header.bar}", false);
    }

    public void testRightOperatorIsBeanLanguage() throws Exception {
        this.assertPredicate("${in.header.foo} == ${bean:generator.generateFilename}", true);
        this.assertPredicate("${in.header.bar} == ${bean:generator.generateId}", true);
        this.assertPredicate("${in.header.bar} >= ${bean:generator.generateId}", true);
    }

    public void testContains() throws Exception {
        this.assertPredicate("${in.header.foo} contains 'a'", true);
        this.assertPredicate("${in.header.foo} contains 'ab'", true);
        this.assertPredicate("${in.header.foo} contains 'abc'", true);
        this.assertPredicate("${in.header.foo} contains 'def'", false);
    }

    public void testNotContains() throws Exception {
        this.assertPredicate("${in.header.foo} not contains 'a'", false);
        this.assertPredicate("${in.header.foo} not contains 'ab'", false);
        this.assertPredicate("${in.header.foo} not contains 'abc'", false);
        this.assertPredicate("${in.header.foo} not contains 'def'", true);
    }

    public void testRegex() throws Exception {
        this.assertPredicate("${in.header.foo} regex '^a..$'", true);
        this.assertPredicate("${in.header.foo} regex '^ab.$'", true);
        this.assertPredicate("${in.header.foo} regex '^ab.$'", true);
        this.assertPredicate("${in.header.foo} regex '^d.*$'", false);
        this.assertPredicate("${in.header.bar} regex '^\\d{3}'", true);
        this.assertPredicate("${in.header.bar} regex '^\\d{2}'", false);
    }

    public void testNotRegex() throws Exception {
        this.assertPredicate("${in.header.foo} not regex '^a..$'", false);
        this.assertPredicate("${in.header.foo} not regex '^ab.$'", false);
        this.assertPredicate("${in.header.foo} not regex '^ab.$'", false);
        this.assertPredicate("${in.header.foo} not regex '^d.*$'", true);
        this.assertPredicate("${in.header.bar} not regex '^\\d{3}'", false);
        this.assertPredicate("${in.header.bar} not regex '^\\d{2}'", true);
    }

    public void testIn() throws Exception {
        this.assertPredicate("${in.header.foo} in 'foo,abc,def'", true);
        this.assertPredicate("${in.header.foo} in ${bean:generator.generateFilename}", true);
        this.assertPredicate("${in.header.foo} in 'foo,abc,def'", true);
        this.assertPredicate("${in.header.foo} in 'foo,def'", false);
        this.assertPredicate("${in.header.bar} in '100,123,200'", true);
        this.assertPredicate("${in.header.bar} in ${bean:generator.generateId}", true);
        this.assertPredicate("${in.header.bar} in '100,200'", false);
    }

    public void testNotIn() throws Exception {
        this.assertPredicate("${in.header.foo} not in 'foo,abc,def'", false);
        this.assertPredicate("${in.header.foo} not in ${bean:generator.generateFilename}", false);
        this.assertPredicate("${in.header.foo} not in 'foo,abc,def'", false);
        this.assertPredicate("${in.header.foo} not in 'foo,def'", true);
        this.assertPredicate("${in.header.bar} not in '100,123,200'", false);
        this.assertPredicate("${in.header.bar} not in ${bean:generator.generateId}", false);
        this.assertPredicate("${in.header.bar} not in '100,200'", true);
    }

    public void testIs() throws Exception {
        this.assertPredicate("${in.header.foo} is 'java.lang.String'", true);
        this.assertPredicate("${in.header.foo} is 'java.lang.Integer'", false);
        this.assertPredicate("${in.header.foo} is 'String'", true);
        this.assertPredicate("${in.header.foo} is 'Integer'", false);
        try {
            this.assertPredicate("${in.header.foo} is com.mycompany.DoesNotExist", false);
            SimpleOperatorTest.fail((String)"Should have thrown an exception");
        }
        catch (SimpleIllegalSyntaxException e) {
            SimpleOperatorTest.assertEquals((int)20, (int)e.getIndex());
        }
    }

    public void testIsNot() throws Exception {
        this.assertPredicate("${in.header.foo} not is 'java.lang.String'", false);
        this.assertPredicate("${in.header.foo} not is 'java.lang.Integer'", true);
        this.assertPredicate("${in.header.foo} not is 'String'", false);
        this.assertPredicate("${in.header.foo} not is 'Integer'", true);
        try {
            this.assertPredicate("${in.header.foo} not is com.mycompany.DoesNotExist", false);
            SimpleOperatorTest.fail((String)"Should have thrown an exception");
        }
        catch (SimpleIllegalSyntaxException e) {
            SimpleOperatorTest.assertEquals((int)24, (int)e.getIndex());
        }
    }

    public void testRange() throws Exception {
        this.assertPredicate("${in.header.bar} range '100..200'", true);
        this.assertPredicate("${in.header.bar} range '200..300'", false);
        this.assertPredicate("${in.header.foo} range '200..300'", false);
        this.assertPredicate("${bean:generator.generateId} range '123..130'", true);
        this.assertPredicate("${bean:generator.generateId} range '120..123'", true);
        this.assertPredicate("${bean:generator.generateId} range '120..122'", false);
        this.assertPredicate("${bean:generator.generateId} range '124..130'", false);
        try {
            this.assertPredicate("${in.header.foo} range abc..200", false);
            SimpleOperatorTest.fail((String)"Should have thrown an exception");
        }
        catch (SimpleIllegalSyntaxException e) {
            SimpleOperatorTest.assertEquals((int)23, (int)e.getIndex());
        }
        try {
            this.assertPredicate("${in.header.foo} range abc..", false);
            SimpleOperatorTest.fail((String)"Should have thrown an exception");
        }
        catch (SimpleIllegalSyntaxException e) {
            SimpleOperatorTest.assertEquals((int)23, (int)e.getIndex());
        }
        try {
            this.assertPredicate("${in.header.foo} range 100.200", false);
            SimpleOperatorTest.fail((String)"Should have thrown an exception");
        }
        catch (SimpleIllegalSyntaxException e) {
            SimpleOperatorTest.assertEquals((int)30, (int)e.getIndex());
        }
        this.assertPredicate("${in.header.bar} range '100..200' && ${in.header.foo} == 'abc'", true);
        this.assertPredicate("${in.header.bar} range '200..300' && ${in.header.foo} == 'abc'", false);
        this.assertPredicate("${in.header.bar} range '200..300' || ${in.header.foo} == 'abc'", true);
        this.assertPredicate("${in.header.bar} range '200..300' || ${in.header.foo} == 'def'", false);
    }

    public void testNotRange() throws Exception {
        this.assertPredicate("${in.header.bar} not range '100..200'", false);
        this.assertPredicate("${in.header.bar} not range '200..300'", true);
        this.assertPredicate("${in.header.foo} not range '200..300'", true);
        this.assertPredicate("${bean:generator.generateId} not range '123..130'", false);
        this.assertPredicate("${bean:generator.generateId} not range '120..123'", false);
        this.assertPredicate("${bean:generator.generateId} not range '120..122'", true);
        this.assertPredicate("${bean:generator.generateId} not range '124..130'", true);
        try {
            this.assertPredicate("${in.header.foo} not range abc..200", false);
            SimpleOperatorTest.fail((String)"Should have thrown an exception");
        }
        catch (SimpleIllegalSyntaxException e) {
            SimpleOperatorTest.assertEquals((int)27, (int)e.getIndex());
        }
        try {
            this.assertPredicate("${in.header.foo} not range abc..", false);
            SimpleOperatorTest.fail((String)"Should have thrown an exception");
        }
        catch (SimpleIllegalSyntaxException e) {
            SimpleOperatorTest.assertEquals((int)27, (int)e.getIndex());
        }
        try {
            this.assertPredicate("${in.header.foo} not range 100.200", false);
            SimpleOperatorTest.fail((String)"Should have thrown an exception");
        }
        catch (SimpleIllegalSyntaxException e) {
            SimpleOperatorTest.assertEquals((int)34, (int)e.getIndex());
        }
    }

    public void testUnaryInc() throws Exception {
        this.assertExpression("${in.header.bar}++", 124);
        this.assertExpression("+++++++++++++", "+++++++++++++");
        this.assertExpression("Logging ++ start ++", "Logging ++ start ++");
        this.assertExpression("Logging +++ start +++", "Logging +++ start +++");
        this.assertExpression("++ start ++", "++ start ++");
        this.assertExpression("+++ start +++", "+++ start +++");
        this.assertPredicate("${in.header.bar}++ == 122", false);
        this.assertPredicate("${in.header.bar}++ == 123", false);
        this.assertPredicate("${in.header.bar}++ == 124", true);
    }

    public void testUnaryDec() throws Exception {
        this.assertExpression("${in.header.bar}--", 122);
        this.assertExpression("-------------", "-------------");
        this.assertExpression("Logging -- start --", "Logging -- start --");
        this.assertExpression("Logging --- start ---", "Logging --- start ---");
        this.assertExpression("-- start --", "-- start --");
        this.assertExpression("--- start ---", "--- start ---");
        this.assertPredicate("${in.header.bar}-- == 122", true);
        this.assertPredicate("${in.header.bar}-- == 123", false);
        this.assertPredicate("${in.header.bar}-- == 124", false);
    }

    public void testStartsWith() throws Exception {
        this.exchange.getIn().setBody((Object)"Hello there");
        this.assertPredicate("${in.body} starts with 'Hello'", true);
        this.assertPredicate("${in.body} starts with 'H'", true);
        this.assertPredicate("${in.body} starts with 'Hello there'", true);
        this.assertPredicate("${in.body} starts with 'Hello ther'", true);
        this.assertPredicate("${in.body} starts with 'ello there'", false);
        this.assertPredicate("${in.body} starts with 'Hi'", false);
    }

    public void testEndsWith() throws Exception {
        this.exchange.getIn().setBody((Object)"Hello there");
        this.assertPredicate("${in.body} ends with 'there'", true);
        this.assertPredicate("${in.body} ends with 're'", true);
        this.assertPredicate("${in.body} ends with ' there'", true);
        this.assertPredicate("${in.body} ends with 'Hello there'", true);
        this.assertPredicate("${in.body} ends with 'Hello ther'", false);
        this.assertPredicate("${in.body} ends with 'Hi'", false);
    }

    @Override
    protected String getLanguageName() {
        return "simple";
    }

    public class MyFileNameGenerator {
        public String generateFilename(Exchange exchange) {
            return "abc";
        }

        public int generateId(Exchange exchange) {
            return 123;
        }
    }
}

