/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;

public class ThreadsRejectedExecutionWithDeadLetterTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testThreadsRejectedExecution() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((RouteDefinition)this.from("seda:start").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:failed")).to("log:before")).threads().maxPoolSize(1).poolSize(1).maxQueueSize(1).rejectedPolicy(ThreadPoolRejectedPolicy.Abort).delay(1000L).to("log:after")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.getMockEndpoint("mock:failed").expectedMessageCount(1);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.template.sendBody("seda:start", (Object)"Hi World");
        this.template.sendBody("seda:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    public void testThreadsRejectedExecutionWithRedelivery() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((RouteDefinition)this.from("seda:start").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:failed").maximumRedeliveries(5)).to("log:before")).threads().maxPoolSize(1).poolSize(1).maxQueueSize(1).rejectedPolicy(ThreadPoolRejectedPolicy.Abort).delay(1000L).to("log:after")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(3);
        this.getMockEndpoint("mock:failed").expectedMessageCount(0);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.template.sendBody("seda:start", (Object)"Hi World");
        this.template.sendBody("seda:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }
}

