/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.lang.reflect.Field;
import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.RoutingSlip;

public class RoutingSlipMemoryLeakTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        RoutingSlipMemoryLeakTest.deleteDirectory("target/output");
        super.setUp();
    }

    public void testMemoryLeakInExceptionHandlerCaching() throws Exception {
        int messageCount = 100;
        for (int i = 0; i < messageCount; ++i) {
            this.template.sendBody("direct:start", (Object)("message " + i));
        }
        RoutingSlip routingSlip = (RoutingSlip)this.context.getProcessor("memory-leak", RoutingSlip.class);
        Map<?, ?> errorHandlers = this.getRoutingSlipErrorHandlers(routingSlip);
        RoutingSlipMemoryLeakTest.assertEquals((String)"Error handlers cache must contain only one value", (int)1, (int)errorHandlers.size());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routingSlip((Expression)this.method(SlipProvider.class)).id("memory-leak");
            }
        };
    }

    private Map<?, ?> getRoutingSlipErrorHandlers(RoutingSlip routingSlip) throws Exception {
        Field errorHandlersField = routingSlip.getClass().getDeclaredField("errorHandlers");
        errorHandlersField.setAccessible(true);
        Map errorHandlers = (Map)errorHandlersField.get(routingSlip);
        return errorHandlers;
    }

    public static class SlipProvider {
        public String computeSlip(String body) {
            return "file:target/output";
        }
    }
}

