/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;

public class RecipientListUseOriginalMessageEndpointExceptionIssueTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        RecipientListUseOriginalMessageEndpointExceptionIssueTest.deleteDirectory("target/inbox");
        RecipientListUseOriginalMessageEndpointExceptionIssueTest.deleteDirectory("target/outbox");
        super.setUp();
    }

    public void testRecipientListUseOriginalMessageIssue() throws Exception {
        this.getMockEndpoint("mock:throwException").whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) throws Exception {
                throw new Exception("Exception raised");
            }
        });
        this.getMockEndpoint("mock:error").expectedMinimumMessageCount(1);
        this.getMockEndpoint("mock:error").expectedFileExists("target/outbox/hello.txt", "A");
        this.template.sendBodyAndHeader("file:target/inbox", (Object)"A", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)this.onException(Exception.class).handled(true).useOriginalMessage().to("file://target/outbox")).to("mock:error");
                ((RouteDefinition)((RouteDefinition)this.from("file://target/inbox").transform((Expression)this.constant("B"))).setHeader("path", (Expression)this.constant("mock:throwException"))).recipientList((Expression)this.header("path")).shareUnitOfWork();
            }
        };
    }
}

