/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class MulticastAggregationStrategyThrowExceptionTest
extends ContextTestSupport {
    public void testThrowException() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead"));
                ((MulticastDefinition)((MulticastDefinition)this.from("direct:start").multicast((AggregationStrategy)new MyAggregateBean()).shareUnitOfWork().to("direct:a")).to("direct:b")).end();
                this.from("direct:a").to("mock:a");
                this.from("direct:b").to("mock:b");
            }
        };
    }

    public static class MyAggregateBean
    implements AggregationStrategy {
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange != null) {
                throw new IllegalArgumentException("Forced");
            }
            return newExchange;
        }
    }
}

