/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.DefaultEndpoint;

public class Camel4857UriIssueTest
extends ContextTestSupport {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.context.addComponent("my", (Component)new MyComponent());
    }

    public void testExclamationInUri() {
        MyEndpoint endpoint = (MyEndpoint)this.context.getEndpoint("my:host:11303/tube1+tube%2B+tube%3F", MyEndpoint.class);
        Camel4857UriIssueTest.assertNotNull((String)"endpoint", (Object)((Object)endpoint));
        Camel4857UriIssueTest.assertEquals((String)"my:host:11303/tube1+tube%2B+tube%3F", (String)endpoint.getUri());
    }

    public void testPath() {
        MyEndpoint endpoint = (MyEndpoint)this.context.getEndpoint("my:host:11303/tube1+tube%2B", MyEndpoint.class);
        Camel4857UriIssueTest.assertEquals((String)"Path contains several tube names, every tube name may have + or ? characters", (String)"host:11303/tube1+tube%2B", (String)endpoint.remaining);
    }

    class MyComponent
    extends DefaultComponent {
        MyComponent() {
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
            return new MyEndpoint(uri, remaining);
        }

        public boolean useRawUri() {
            return true;
        }
    }

    class MyEndpoint
    extends DefaultEndpoint {
        String uri;
        String remaining;

        MyEndpoint(String uri, String remaining) {
            this.uri = uri;
            this.remaining = remaining;
        }

        public Producer createProducer() throws Exception {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isSingleton() {
            return true;
        }

        public String getUri() {
            return this.uri;
        }
    }
}

