/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class ZipDataFormatFileDeleteTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        ZipDataFormatFileDeleteTest.deleteDirectory("target/zip");
        super.setUp();
    }

    public void testZipFileDelete() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBodyAndHeader("file:target/zip", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        File in = new File("target/zip/hello.txt");
        ZipDataFormatFileDeleteTest.assertFalse((String)("Should have been deleted " + in), (boolean)in.exists());
        File out = new File("target/zip/out/hello.txt.zip");
        ZipDataFormatFileDeleteTest.assertTrue((String)("Should have been created " + out), (boolean)out.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file:target/zip?delete=true").marshal().zip().to("file:target/zip/out?fileName=${file:name}.zip")).to("mock:result");
            }
        };
    }
}

