/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.ByteArrayInputStream;
import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;

public class StringDataFormatTest
extends TestSupport {
    private CamelContext context;
    private ProducerTemplate template;

    protected void setUp() throws Exception {
        this.context = new DefaultCamelContext();
        this.context.setTracing(Boolean.valueOf(true));
        this.template = this.context.createProducerTemplate();
        this.template.start();
    }

    protected void tearDown() throws Exception {
        this.template.stop();
        this.context.stop();
    }

    public void testMarshalUTF8() throws Exception {
        String title = "Hello Thai Elephant \u0e08";
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").marshal().string("UTF-8").process((Processor)new MyBookProcessor("UTF-8", "Hello Thai Elephant \u0e08"));
            }
        });
        this.context.start();
        MyBook book = new MyBook();
        book.setTitle("Hello Thai Elephant \u0e08");
        this.template.sendBody("direct:start", (Object)book);
    }

    public void testMarshalNoEncoding() throws Exception {
        String title = "Hello World";
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").marshal().string().process((Processor)new MyBookProcessor(null, "Hello World"));
            }
        });
        this.context.start();
        MyBook book = new MyBook();
        book.setTitle("Hello World");
        this.template.sendBody("direct:start", (Object)book);
    }

    public void testUnmarshalUTF8() throws Exception {
        String title = "Hello Thai Elephant \u0e08";
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").unmarshal().string("UTF-8").to("mock:unmarshal");
            }
        });
        this.context.start();
        byte[] bytes = "Hello Thai Elephant \u0e08".getBytes("UTF-8");
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.template.sendBody("direct:start", (Object)in);
        MockEndpoint mock = (MockEndpoint)this.context.getEndpoint("mock:unmarshal", MockEndpoint.class);
        mock.setExpectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"Hello Thai Elephant \u0e08"});
    }

    public void testUnmarshalNoEncoding() throws Exception {
        String title = "Hello World";
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").unmarshal().string().to("mock:unmarshal");
            }
        });
        this.context.start();
        byte[] bytes = "Hello World".getBytes();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.template.sendBody("direct:start", (Object)in);
        MockEndpoint mock = (MockEndpoint)this.context.getEndpoint("mock:unmarshal", MockEndpoint.class);
        mock.setExpectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
    }

    private static class MyBook {
        private String title;

        private MyBook() {
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String toString() {
            return this.title;
        }
    }

    private static class MyBookProcessor
    implements Processor {
        private String encoding;
        private String title;

        MyBookProcessor(String encoding, String title) {
            this.encoding = encoding;
            this.title = title;
        }

        public void process(Exchange exchange) throws Exception {
            byte[] body = (byte[])exchange.getIn().getBody(byte[].class);
            String text = this.encoding != null ? new String(body, this.encoding) : new String(body);
            TestCase.assertEquals((String)text, (String)this.title);
        }
    }
}

