/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class PendingExchangesShutdownGracefulTest
extends ContextTestSupport {
    private static String foo = "";
    private static CountDownLatch latch = new CountDownLatch(1);

    public void testShutdownGraceful() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMinimumMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"A");
        this.template.sendBody("seda:foo", (Object)"B");
        this.template.sendBody("seda:foo", (Object)"C");
        this.template.sendBody("seda:foo", (Object)"D");
        this.template.sendBody("seda:foo", (Object)"E");
        this.assertMockEndpointsSatisfied();
        PendingExchangesShutdownGracefulTest.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        this.context.stop();
        PendingExchangesShutdownGracefulTest.assertEquals((String)"Should graceful shutdown", (String)"ABCDE", (String)foo);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("seda:foo").to("mock:foo")).delay(500L).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        foo = foo + (String)exchange.getIn().getBody(String.class);
                        latch.countDown();
                    }
                });
            }
        };
    }
}

