/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Arrays;
import java.util.List;
import javax.naming.Context;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.TestSupport;
import org.apache.camel.component.log.LogComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DummyLifecycleStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.util.jndi.JndiContext;

public class MultipleLifecycleStrategyTest
extends TestSupport {
    private DummyLifecycleStrategy dummy1 = new DummyLifecycleStrategy();
    private DummyLifecycleStrategy dummy2 = new DummyLifecycleStrategy();

    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext((Context)new JndiContext());
        context.addLifecycleStrategy((LifecycleStrategy)this.dummy1);
        context.addLifecycleStrategy((LifecycleStrategy)this.dummy2);
        return context;
    }

    public void testMultipleLifecycleStrategies() throws Exception {
        CamelContext context = this.createCamelContext();
        context.start();
        LogComponent log = new LogComponent();
        context.addComponent("log", (Component)log);
        context.addEndpoint("log:/foo", log.createEndpoint("log://foo"));
        context.removeComponent("log");
        context.stop();
        List<String> expectedEvents = Arrays.asList("onContextStart", "onServiceAdd", "onServiceAdd", "onServiceAdd", "onServiceAdd", "onServiceAdd", "onServiceAdd", "onServiceAdd", "onServiceAdd", "onServiceAdd", "onServiceAdd", "onServiceAdd", "onComponentAdd", "onEndpointAdd", "onComponentRemove", "onContextStop");
        MultipleLifecycleStrategyTest.assertEquals(expectedEvents, this.dummy1.getEvents());
        MultipleLifecycleStrategyTest.assertEquals(expectedEvents, this.dummy2.getEvents());
    }
}

