/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.impl.TraceExchangeFormatter;
import org.apache.camel.model.RouteDefinition;

public class LogDebugBodyMaxCharsOffTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.context.getProperties().put("CamelLogDebugBodyMaxChars", "-1");
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("logFormatter", (Object)new TraceExchangeFormatter());
        return jndi;
    }

    public void testLogBodyMaxLengthTest() throws Exception {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 1000; ++i) {
            int value = i % 10;
            sb.append(value);
        }
        String body = sb.toString();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
        TraceExchangeFormatter myFormatter = (TraceExchangeFormatter)((Object)this.context.getRegistry().lookupByNameAndType("logFormatter", TraceExchangeFormatter.class));
        String msg = myFormatter.getMessage();
        LogDebugBodyMaxCharsOffTest.assertTrue((boolean)msg.endsWith("Body: [Body is not logged]]"));
        LogDebugBodyMaxCharsOffTest.assertNotSame((String)"clipped log and real body should not be the same", (Object)msg, (Object)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody(String.class));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
            }
        };
    }
}

