/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import junit.framework.TestCase;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultHeaderFilterStrategy;
import org.apache.camel.impl.HeaderFilterStrategyComponent;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;

public class HeaderFilterStrategyComponentTest
extends TestCase {
    public void testHeaderFilterStrategyComponent() {
        MyComponent comp = new MyComponent(MyEndpoint.class);
        HeaderFilterStrategyComponentTest.assertNull((Object)comp.getHeaderFilterStrategy());
        DefaultHeaderFilterStrategy strategy = new DefaultHeaderFilterStrategy();
        comp.setHeaderFilterStrategy((HeaderFilterStrategy)strategy);
        HeaderFilterStrategyComponentTest.assertSame((Object)strategy, (Object)comp.getHeaderFilterStrategy());
    }

    public void testHeaderFilterStrategyAware() {
        MyComponent comp = new MyComponent(MyEndpoint.class);
        HeaderFilterStrategyComponentTest.assertNull((Object)comp.getHeaderFilterStrategy());
        DefaultHeaderFilterStrategy strategy = new DefaultHeaderFilterStrategy();
        comp.setHeaderFilterStrategy((HeaderFilterStrategy)strategy);
        MyEndpoint my = new MyEndpoint();
        comp.setEndpointHeaderFilterStrategy((Endpoint)my);
        HeaderFilterStrategyComponentTest.assertSame((Object)strategy, (Object)my.getHeaderFilterStrategy());
        HeaderFilterStrategyComponentTest.assertSame((Object)strategy, (Object)comp.getHeaderFilterStrategy());
    }

    private static class MyEndpoint
    extends DefaultEndpoint
    implements HeaderFilterStrategyAware {
        private HeaderFilterStrategy strategy;

        private MyEndpoint() {
        }

        public HeaderFilterStrategy getHeaderFilterStrategy() {
            return this.strategy;
        }

        public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
            this.strategy = strategy;
        }

        public Producer createProducer() throws Exception {
            return null;
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            return null;
        }

        public boolean isSingleton() {
            return true;
        }
    }

    private static class MyComponent
    extends HeaderFilterStrategyComponent {
        MyComponent(Class<? extends Endpoint> endpointClass) {
            super(endpointClass);
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
            return null;
        }
    }
}

