/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;

public class DefaultProducerTemplateAsyncTest
extends ContextTestSupport {
    private static final AtomicInteger ORDER = new AtomicInteger(0);

    public void testRequestAsync() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Hello");
        Future future = this.template.asyncSend("direct:start", (Exchange)exchange);
        long start = System.currentTimeMillis();
        String echo = (String)this.template.requestBody("direct:echo", (Object)"Hi", String.class);
        DefaultProducerTemplateAsyncTest.assertEquals((String)"HiHi", (String)echo);
        Exchange result = (Exchange)future.get();
        long delta = System.currentTimeMillis() - start;
        DefaultProducerTemplateAsyncTest.assertEquals((Object)"Hello World", (Object)result.getIn().getBody());
        DefaultProducerTemplateAsyncTest.assertTrue((String)("Should take longer than: " + delta), (delta > 250L ? 1 : 0) != 0);
        this.assertMockEndpointsSatisfied();
    }

    public void testSendAsyncProcessor() throws Exception {
        Future future = this.template.asyncSend("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Hello");
            }
        });
        long start = System.currentTimeMillis();
        String echo = (String)this.template.requestBody("direct:echo", (Object)"Hi", String.class);
        DefaultProducerTemplateAsyncTest.assertEquals((String)"HiHi", (String)echo);
        Exchange result = (Exchange)future.get();
        long delta = System.currentTimeMillis() - start;
        DefaultProducerTemplateAsyncTest.assertEquals((Object)"Hello World", (Object)result.getIn().getBody());
        DefaultProducerTemplateAsyncTest.assertTrue((String)("Should take longer than: " + delta), (delta > 250L ? 1 : 0) != 0);
    }

    public void testRequestAsyncBody() throws Exception {
        Future future = this.template.asyncRequestBody("direct:start", (Object)"Hello");
        long start = System.currentTimeMillis();
        String echo = (String)this.template.requestBody("direct:echo", (Object)"Hi", String.class);
        DefaultProducerTemplateAsyncTest.assertEquals((String)"HiHi", (String)echo);
        String result = (String)this.template.extractFutureBody(future, String.class);
        long delta = System.currentTimeMillis() - start;
        DefaultProducerTemplateAsyncTest.assertEquals((String)"Hello World", (String)result);
        DefaultProducerTemplateAsyncTest.assertTrue((String)("Should take longer than: " + delta), (delta > 250L ? 1 : 0) != 0);
    }

    public void testRequestAsyncBodyType() throws Exception {
        Future future = this.template.asyncRequestBody("direct:start", (Object)"Hello", String.class);
        long start = System.currentTimeMillis();
        String echo = (String)this.template.requestBody("direct:echo", (Object)"Hi", String.class);
        DefaultProducerTemplateAsyncTest.assertEquals((String)"HiHi", (String)echo);
        String result = (String)future.get();
        long delta = System.currentTimeMillis() - start;
        DefaultProducerTemplateAsyncTest.assertEquals((String)"Hello World", (String)result);
        DefaultProducerTemplateAsyncTest.assertTrue((String)("Should take longer than: " + delta), (delta > 250L ? 1 : 0) != 0);
    }

    public void testRequestAsyncBodyAndHeader() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedHeaderReceived("foo", (Object)123);
        Future future = this.template.asyncRequestBodyAndHeader("direct:start", (Object)"Hello", "foo", (Object)123);
        long start = System.currentTimeMillis();
        String echo = (String)this.template.requestBody("direct:echo", (Object)"Hi", String.class);
        DefaultProducerTemplateAsyncTest.assertEquals((String)"HiHi", (String)echo);
        String result = (String)this.template.extractFutureBody(future, String.class);
        this.assertMockEndpointsSatisfied();
        long delta = System.currentTimeMillis() - start;
        DefaultProducerTemplateAsyncTest.assertEquals((String)"Hello World", (String)result);
        DefaultProducerTemplateAsyncTest.assertTrue((String)("Should take longer than: " + delta), (delta > 250L ? 1 : 0) != 0);
    }

    public void testRequestAsyncBodyAndHeaderType() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedHeaderReceived("foo", (Object)123);
        Future future = this.template.asyncRequestBodyAndHeader("direct:start", (Object)"Hello", "foo", (Object)123, String.class);
        long start = System.currentTimeMillis();
        String echo = (String)this.template.requestBody("direct:echo", (Object)"Hi", String.class);
        DefaultProducerTemplateAsyncTest.assertEquals((String)"HiHi", (String)echo);
        String result = (String)future.get();
        this.assertMockEndpointsSatisfied();
        long delta = System.currentTimeMillis() - start;
        DefaultProducerTemplateAsyncTest.assertEquals((String)"Hello World", (String)result);
        DefaultProducerTemplateAsyncTest.assertTrue((String)("Should take longer than: " + delta), (delta > 250L ? 1 : 0) != 0);
    }

    public void testRequestAsyncBodyAndHeaders() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedHeaderReceived("foo", (Object)123);
        mock.expectedHeaderReceived("bar", (Object)"cheese");
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("foo", 123);
        headers.put("bar", "cheese");
        Future future = this.template.asyncRequestBodyAndHeaders("direct:start", (Object)"Hello", headers);
        long start = System.currentTimeMillis();
        String echo = (String)this.template.requestBody("direct:echo", (Object)"Hi", String.class);
        DefaultProducerTemplateAsyncTest.assertEquals((String)"HiHi", (String)echo);
        String result = (String)this.template.extractFutureBody(future, String.class);
        this.assertMockEndpointsSatisfied();
        long delta = System.currentTimeMillis() - start;
        DefaultProducerTemplateAsyncTest.assertEquals((String)"Hello World", (String)result);
        DefaultProducerTemplateAsyncTest.assertTrue((String)("Should take longer than: " + delta), (delta > 250L ? 1 : 0) != 0);
    }

    public void testRequestAsyncBodyAndHeadersType() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedHeaderReceived("foo", (Object)123);
        mock.expectedHeaderReceived("bar", (Object)"cheese");
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("foo", 123);
        headers.put("bar", "cheese");
        Future future = this.template.asyncRequestBodyAndHeaders("direct:start", (Object)"Hello", headers, String.class);
        long start = System.currentTimeMillis();
        String echo = (String)this.template.requestBody("direct:echo", (Object)"Hi", String.class);
        DefaultProducerTemplateAsyncTest.assertEquals((String)"HiHi", (String)echo);
        String result = (String)future.get();
        this.assertMockEndpointsSatisfied();
        long delta = System.currentTimeMillis() - start;
        DefaultProducerTemplateAsyncTest.assertEquals((String)"Hello World", (String)result);
        DefaultProducerTemplateAsyncTest.assertTrue((String)("Should take longer than: " + delta), (delta > 250L ? 1 : 0) != 0);
    }

    public void testRequestAsyncErrorWhenProcessing() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Hello");
        Future future = this.template.asyncRequestBody("direct:error", (Object)exchange);
        long start = System.currentTimeMillis();
        String echo = (String)this.template.requestBody("direct:echo", (Object)"Hi", String.class);
        DefaultProducerTemplateAsyncTest.assertEquals((String)"HiHi", (String)echo);
        try {
            this.template.extractFutureBody(future, Exchange.class);
            DefaultProducerTemplateAsyncTest.fail((String)"Should have thrown exception");
        }
        catch (RuntimeCamelException e) {
            DefaultProducerTemplateAsyncTest.assertEquals((String)"Damn forced by unit test", (String)e.getCause().getMessage());
        }
        long delta = System.currentTimeMillis() - start;
        DefaultProducerTemplateAsyncTest.assertTrue((String)("Should take longer than: " + delta), (delta > 250L ? 1 : 0) != 0);
    }

    public void testRequestAsyncBodyErrorWhenProcessing() throws Exception {
        Future future = this.template.asyncRequestBody("direct:error", (Object)"Hello");
        long start = System.currentTimeMillis();
        String echo = (String)this.template.requestBody("direct:echo", (Object)"Hi", String.class);
        DefaultProducerTemplateAsyncTest.assertEquals((String)"HiHi", (String)echo);
        try {
            this.template.extractFutureBody(future, String.class);
            DefaultProducerTemplateAsyncTest.fail((String)"Should have thrown exception");
        }
        catch (RuntimeCamelException e) {
            DefaultProducerTemplateAsyncTest.assertEquals((String)"Damn forced by unit test", (String)e.getCause().getMessage());
        }
        long delta = System.currentTimeMillis() - start;
        DefaultProducerTemplateAsyncTest.assertTrue((String)("Should take longer than: " + delta), (delta > 250L ? 1 : 0) != 0);
    }

    public void testAsyncCallbackExchangeInOnly() throws Exception {
        ORDER.set(0);
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        final CountDownLatch latch = new CountDownLatch(1);
        Exchange exchange = this.context.getEndpoint("direct:start").createExchange();
        exchange.getIn().setBody((Object)"Hello");
        this.template.asyncCallback("direct:start", exchange, (Synchronization)new SynchronizationAdapter(){

            public void onDone(Exchange exchange) {
                TestCase.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
                ORDER.addAndGet(2);
                latch.countDown();
            }
        });
        ORDER.addAndGet(1);
        DefaultProducerTemplateAsyncTest.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        ORDER.addAndGet(4);
        this.assertMockEndpointsSatisfied();
        DefaultProducerTemplateAsyncTest.assertEquals((int)7, (int)ORDER.get());
    }

    public void testAsyncCallbackExchangeInOut() throws Exception {
        ORDER.set(0);
        final CountDownLatch latch = new CountDownLatch(1);
        Exchange exchange = this.context.getEndpoint("direct:start").createExchange();
        exchange.getIn().setBody((Object)"Hello");
        exchange.setPattern(ExchangePattern.InOut);
        this.template.asyncCallback("direct:echo", exchange, (Synchronization)new SynchronizationAdapter(){

            public void onDone(Exchange exchange) {
                TestCase.assertEquals((Object)"HelloHello", (Object)exchange.getOut().getBody());
                ORDER.addAndGet(2);
                latch.countDown();
            }
        });
        ORDER.addAndGet(1);
        DefaultProducerTemplateAsyncTest.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        ORDER.addAndGet(4);
        DefaultProducerTemplateAsyncTest.assertEquals((int)7, (int)ORDER.get());
    }

    public void testAsyncCallbackExchangeInOnlyGetResult() throws Exception {
        ORDER.set(0);
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        Exchange exchange = this.context.getEndpoint("direct:start").createExchange();
        exchange.getIn().setBody((Object)"Hello");
        Future future = this.template.asyncCallback("direct:start", exchange, (Synchronization)new SynchronizationAdapter(){

            public void onDone(Exchange exchange) {
                TestCase.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
                ORDER.addAndGet(2);
            }
        });
        ORDER.addAndGet(1);
        Exchange reply = (Exchange)future.get(10L, TimeUnit.SECONDS);
        ORDER.addAndGet(4);
        this.assertMockEndpointsSatisfied();
        DefaultProducerTemplateAsyncTest.assertEquals((int)7, (int)ORDER.get());
        DefaultProducerTemplateAsyncTest.assertNotNull((Object)reply);
    }

    public void testAsyncCallbackExchangeInOutGetResult() throws Exception {
        ORDER.set(0);
        Exchange exchange = this.context.getEndpoint("direct:start").createExchange();
        exchange.getIn().setBody((Object)"Hello");
        exchange.setPattern(ExchangePattern.InOut);
        Future future = this.template.asyncCallback("direct:echo", exchange, (Synchronization)new SynchronizationAdapter(){

            public void onDone(Exchange exchange) {
                TestCase.assertEquals((Object)"HelloHello", (Object)exchange.getOut().getBody());
                ORDER.addAndGet(2);
            }
        });
        ORDER.addAndGet(1);
        Exchange reply = (Exchange)future.get(10L, TimeUnit.SECONDS);
        ORDER.addAndGet(4);
        DefaultProducerTemplateAsyncTest.assertEquals((int)7, (int)ORDER.get());
        DefaultProducerTemplateAsyncTest.assertNotNull((Object)reply);
        DefaultProducerTemplateAsyncTest.assertEquals((Object)"HelloHello", (Object)reply.getOut().getBody());
    }

    public void testAsyncCallbackBodyInOnly() throws Exception {
        ORDER.set(0);
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        final CountDownLatch latch = new CountDownLatch(1);
        this.template.asyncCallbackSendBody("direct:start", (Object)"Hello", (Synchronization)new SynchronizationAdapter(){

            public void onDone(Exchange exchange) {
                TestCase.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
                ORDER.addAndGet(2);
                latch.countDown();
            }
        });
        ORDER.addAndGet(1);
        DefaultProducerTemplateAsyncTest.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        ORDER.addAndGet(4);
        this.assertMockEndpointsSatisfied();
        DefaultProducerTemplateAsyncTest.assertEquals((int)7, (int)ORDER.get());
    }

    public void testAsyncCallbackBodyInOut() throws Exception {
        ORDER.set(0);
        final CountDownLatch latch = new CountDownLatch(1);
        this.template.asyncCallbackRequestBody("direct:echo", (Object)"Hello", (Synchronization)new SynchronizationAdapter(){

            public void onDone(Exchange exchange) {
                TestCase.assertEquals((Object)"HelloHello", (Object)exchange.getOut().getBody());
                ORDER.addAndGet(2);
                latch.countDown();
            }
        });
        ORDER.addAndGet(1);
        DefaultProducerTemplateAsyncTest.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        ORDER.addAndGet(4);
        DefaultProducerTemplateAsyncTest.assertEquals((int)7, (int)ORDER.get());
    }

    public void testAsyncCallbackBodyInOnlyGetResult() throws Exception {
        ORDER.set(0);
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        Future future = this.template.asyncCallbackSendBody("direct:start", (Object)"Hello", (Synchronization)new SynchronizationAdapter(){

            public void onDone(Exchange exchange) {
                TestCase.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
                ORDER.addAndGet(2);
            }
        });
        ORDER.addAndGet(1);
        Object reply = future.get(10L, TimeUnit.SECONDS);
        ORDER.addAndGet(4);
        this.assertMockEndpointsSatisfied();
        DefaultProducerTemplateAsyncTest.assertEquals((int)7, (int)ORDER.get());
        DefaultProducerTemplateAsyncTest.assertEquals(null, reply);
    }

    public void testAsyncCallbackBodyInOutGetResult() throws Exception {
        ORDER.set(0);
        Future future = this.template.asyncCallbackRequestBody("direct:echo", (Object)"Hello", (Synchronization)new SynchronizationAdapter(){

            public void onDone(Exchange exchange) {
                TestCase.assertEquals((Object)"HelloHello", (Object)exchange.getOut().getBody());
                ORDER.addAndGet(2);
            }
        });
        ORDER.addAndGet(1);
        Object reply = future.get(10L, TimeUnit.SECONDS);
        ORDER.addAndGet(4);
        DefaultProducerTemplateAsyncTest.assertEquals((int)7, (int)ORDER.get());
        DefaultProducerTemplateAsyncTest.assertEquals((Object)"HelloHello", reply);
    }

    public void testAsyncCallbackInOnlyProcessor() throws Exception {
        ORDER.set(0);
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        final CountDownLatch latch = new CountDownLatch(1);
        this.template.asyncCallback("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Hello");
            }
        }, (Synchronization)new SynchronizationAdapter(){

            public void onDone(Exchange exchange) {
                TestCase.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
                ORDER.addAndGet(2);
                latch.countDown();
            }
        });
        ORDER.addAndGet(1);
        DefaultProducerTemplateAsyncTest.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        ORDER.addAndGet(4);
        this.assertMockEndpointsSatisfied();
        DefaultProducerTemplateAsyncTest.assertEquals((int)7, (int)ORDER.get());
    }

    public void testAsyncCallbackInOutProcessor() throws Exception {
        ORDER.set(0);
        final CountDownLatch latch = new CountDownLatch(1);
        this.template.asyncCallback("direct:echo", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Hello");
                exchange.setPattern(ExchangePattern.InOut);
            }
        }, (Synchronization)new SynchronizationAdapter(){

            public void onDone(Exchange exchange) {
                TestCase.assertEquals((Object)"HelloHello", (Object)exchange.getOut().getBody());
                ORDER.addAndGet(2);
                latch.countDown();
            }
        });
        ORDER.addAndGet(1);
        DefaultProducerTemplateAsyncTest.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        ORDER.addAndGet(4);
        DefaultProducerTemplateAsyncTest.assertEquals((int)7, (int)ORDER.get());
    }

    public void testAsyncCallbackThreadsInOutProcessor() throws Exception {
        ORDER.set(0);
        final CountDownLatch latch = new CountDownLatch(1);
        this.template.asyncCallback("direct:threads", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Bye");
                exchange.setPattern(ExchangePattern.InOut);
            }
        }, (Synchronization)new SynchronizationAdapter(){

            public void onDone(Exchange exchange) {
                TestCase.assertEquals((Object)"ByeBye", (Object)exchange.getOut().getBody());
                ORDER.addAndGet(2);
                latch.countDown();
            }
        });
        ORDER.addAndGet(1);
        DefaultProducerTemplateAsyncTest.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        ORDER.addAndGet(4);
        DefaultProducerTemplateAsyncTest.assertEquals((int)7, (int)ORDER.get());
    }

    public void testAsyncCallbackExchangeInOnlyWithFailure() throws Exception {
        ORDER.set(0);
        final CountDownLatch latch = new CountDownLatch(1);
        Exchange exchange = this.context.getEndpoint("direct:error").createExchange();
        exchange.getIn().setBody((Object)"Hello");
        this.template.asyncCallback("direct:error", exchange, (Synchronization)new SynchronizationAdapter(){

            public void onFailure(Exchange exchange) {
                TestCase.assertEquals((String)"Damn forced by unit test", (String)exchange.getException().getMessage());
                ORDER.addAndGet(2);
                latch.countDown();
            }
        });
        ORDER.addAndGet(1);
        DefaultProducerTemplateAsyncTest.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        ORDER.addAndGet(4);
        DefaultProducerTemplateAsyncTest.assertEquals((int)7, (int)ORDER.get());
    }

    public void testAsyncCallbackExchangeInOutWithFailure() throws Exception {
        ORDER.set(0);
        final CountDownLatch latch = new CountDownLatch(1);
        Exchange exchange = this.context.getEndpoint("direct:error").createExchange();
        exchange.getIn().setBody((Object)"Hello");
        exchange.setPattern(ExchangePattern.InOut);
        this.template.asyncCallback("direct:error", exchange, (Synchronization)new SynchronizationAdapter(){

            public void onFailure(Exchange exchange) {
                TestCase.assertEquals((String)"Damn forced by unit test", (String)exchange.getException().getMessage());
                ORDER.addAndGet(2);
                latch.countDown();
            }
        });
        ORDER.addAndGet(1);
        DefaultProducerTemplateAsyncTest.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        ORDER.addAndGet(4);
        DefaultProducerTemplateAsyncTest.assertEquals((int)7, (int)ORDER.get());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)this.from("direct:start").delay(400L).transform((Expression)this.body().append((Object)" World"))).to("mock:result");
                this.from("direct:error").delay(400L).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new IllegalArgumentException("Damn forced by unit test");
                    }
                });
                this.from("direct:echo").transform((Expression)this.body().append((Object)this.body()));
                this.from("direct:threads").threads(5).transform((Expression)this.body().append((Object)this.body()));
            }
        };
    }
}

