/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.util.URISupport;

public class DefaultEndpointTest
extends ContextTestSupport {
    public void testSanitizeUri() {
        DefaultEndpointTest.assertNull((Object)URISupport.sanitizeUri(null));
        DefaultEndpointTest.assertEquals((String)"", (String)URISupport.sanitizeUri((String)""));
        this.assertSanitizedUriUnchanged("http://camel.apache.org");
        this.assertSanitizedUriUnchanged("irc://irc.codehaus.org/camel");
        this.assertSanitizedUriUnchanged("direct:foo?bar=123&cheese=yes");
        this.assertSanitizedUriUnchanged("https://issues.apache.org/activemq/secure/AddComment!default.jspa?id=33239");
        DefaultEndpointTest.assertEquals((String)"ftp://host.mysite.com/records?passiveMode=true&user=someuser&password=xxxxxx", (String)URISupport.sanitizeUri((String)"ftp://host.mysite.com/records?passiveMode=true&user=someuser&password=superSecret"));
        DefaultEndpointTest.assertEquals((String)"sftp://host.mysite.com/records?user=someuser&privateKeyFile=key.file&privateKeyFilePassphrase=xxxxxx&knownHostsFile=hosts.list", (String)URISupport.sanitizeUri((String)"sftp://host.mysite.com/records?user=someuser&privateKeyFile=key.file&privateKeyFilePassphrase=superSecret&knownHostsFile=hosts.list"));
        DefaultEndpointTest.assertEquals((String)"aws-sqs://MyQueue?accessKey=1672t4rflhnhli3&secretKey=xxxxxx", (String)URISupport.sanitizeUri((String)"aws-sqs://MyQueue?accessKey=1672t4rflhnhli3&secretKey=qi472qfberu33dqjncq"));
    }

    public void testToString() {
        String epstr = "myep:///test";
        MyEndpoint ep = new MyEndpoint();
        ep.setEndpointUri("myep:///test");
        DefaultEndpointTest.assertTrue((ep.toString().indexOf("myep:///test") > 0 ? 1 : 0) != 0);
    }

    private void assertSanitizedUriUnchanged(String uri) {
        DefaultEndpointTest.assertEquals((String)uri, (String)URISupport.sanitizeUri((String)uri));
    }

    private static class MyEndpoint
    extends DefaultEndpoint {
        private MyEndpoint() {
        }

        public Producer createProducer() throws Exception {
            return null;
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            return null;
        }

        public boolean isSingleton() {
            return false;
        }
    }
}

