/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.BeanComponent;
import org.apache.camel.component.direct.DirectComponent;
import org.apache.camel.component.log.LogComponent;
import org.apache.camel.impl.ActiveMQUuidGenerator;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.CamelContextHelper;

public class DefaultCamelContextTest
extends TestSupport {
    public void testAutoCreateComponentsOn() {
        DefaultCamelContext ctx = new DefaultCamelContext();
        ctx.disableJMX();
        Component component = ctx.getComponent("bean");
        DefaultCamelContextTest.assertNotNull((Object)component);
        DefaultCamelContextTest.assertEquals(component.getClass(), BeanComponent.class);
    }

    public void testAutoCreateComponentsOff() {
        DefaultCamelContext ctx = new DefaultCamelContext();
        ctx.disableJMX();
        ctx.setAutoCreateComponents(false);
        Component component = ctx.getComponent("bean");
        DefaultCamelContextTest.assertNull((Object)component);
    }

    public void testCreateDefaultUuidGenerator() {
        DefaultCamelContext ctx = new DefaultCamelContext();
        ctx.disableJMX();
        UuidGenerator uuidGenerator = ctx.getUuidGenerator();
        DefaultCamelContextTest.assertNotNull((Object)uuidGenerator);
        DefaultCamelContextTest.assertEquals(uuidGenerator.getClass(), ActiveMQUuidGenerator.class);
    }

    public void testGetComponents() throws Exception {
        DefaultCamelContext ctx = new DefaultCamelContext();
        ctx.disableJMX();
        Component component = ctx.getComponent("bean");
        DefaultCamelContextTest.assertNotNull((Object)component);
        List list = ctx.getComponentNames();
        DefaultCamelContextTest.assertEquals((int)1, (int)list.size());
        DefaultCamelContextTest.assertEquals((String)"bean", (String)((String)list.get(0)));
    }

    public void testGetEndpoint() throws Exception {
        DefaultCamelContext ctx = new DefaultCamelContext();
        ctx.disableJMX();
        Endpoint endpoint = ctx.getEndpoint("log:foo");
        DefaultCamelContextTest.assertNotNull((Object)endpoint);
        try {
            ctx.getEndpoint(null);
            DefaultCamelContextTest.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetEndPointByTypeUnknown() {
        DefaultCamelContext camelContext = new DefaultCamelContext();
        try {
            camelContext.getEndpoint("xxx", Endpoint.class);
            DefaultCamelContextTest.fail();
        }
        catch (NoSuchEndpointException e) {
            DefaultCamelContextTest.assertEquals((String)"No endpoint could be found for: xxx, please check your classpath contains the needed Camel component jar.", (String)e.getMessage());
        }
    }

    public void testRemoveEndpoint() throws Exception {
        DefaultCamelContext ctx = new DefaultCamelContext();
        ctx.disableJMX();
        ctx.getEndpoint("log:foo");
        ctx.getEndpoint("log:bar");
        Collection list = ctx.removeEndpoints("log:foo");
        DefaultCamelContextTest.assertEquals((int)1, (int)list.size());
        DefaultCamelContextTest.assertEquals((String)"log://foo", (String)((Endpoint)list.iterator().next()).getEndpointUri());
        ctx.getEndpoint("log:baz");
        ctx.getEndpoint("seda:cool");
        list = ctx.removeEndpoints("log:*");
        DefaultCamelContextTest.assertEquals((int)2, (int)list.size());
        Iterator it = list.iterator();
        DefaultCamelContextTest.assertEquals((String)"log://bar", (String)((Endpoint)it.next()).getEndpointUri());
        DefaultCamelContextTest.assertEquals((String)"log://baz", (String)((Endpoint)it.next()).getEndpointUri());
        DefaultCamelContextTest.assertEquals((int)1, (int)ctx.getEndpoints().size());
    }

    public void testGetEndpointNotFound() throws Exception {
        DefaultCamelContext ctx = new DefaultCamelContext();
        ctx.disableJMX();
        try {
            ctx.getEndpoint("xxx:foo");
            DefaultCamelContextTest.fail((String)"Should have thrown a ResolveEndpointFailedException");
        }
        catch (ResolveEndpointFailedException e) {
            DefaultCamelContextTest.assertTrue((boolean)e.getMessage().contains("No component found with scheme: xxx"));
        }
    }

    public void testGetEndpointNoScheme() throws Exception {
        DefaultCamelContext ctx = new DefaultCamelContext();
        ctx.disableJMX();
        try {
            CamelContextHelper.getMandatoryEndpoint((CamelContext)ctx, (String)"log.foo");
            DefaultCamelContextTest.fail((String)"Should have thrown a NoSuchEndpointException");
        }
        catch (NoSuchEndpointException noSuchEndpointException) {
            // empty catch block
        }
    }

    public void testRestartCamelContext() throws Exception {
        DefaultCamelContext ctx = new DefaultCamelContext();
        ctx.disableJMX();
        ctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:endpointA").to("mock:endpointB");
            }
        });
        ctx.start();
        DefaultCamelContextTest.assertEquals((String)"Should have one RouteService", (int)1, (int)ctx.getRouteServices().size());
        String routesString = ctx.getRoutes().toString();
        ctx.stop();
        DefaultCamelContextTest.assertEquals((String)"The RouteService should NOT be removed even when we stop", (int)1, (int)ctx.getRouteServices().size());
        ctx.start();
        DefaultCamelContextTest.assertEquals((String)"Should have one RouteService", (int)1, (int)ctx.getRouteServices().size());
        DefaultCamelContextTest.assertEquals((String)"The Routes should be same", (String)routesString, (String)ctx.getRoutes().toString());
        ctx.stop();
        DefaultCamelContextTest.assertEquals((String)"The RouteService should NOT be removed even when we stop", (int)1, (int)ctx.getRouteServices().size());
    }

    public void testName() {
        DefaultCamelContext ctx = new DefaultCamelContext();
        ctx.disableJMX();
        DefaultCamelContextTest.assertNotNull((String)"Should have a default name", (Object)ctx.getName());
        ctx.setName("foo");
        DefaultCamelContextTest.assertEquals((String)"foo", (String)ctx.getName());
        DefaultCamelContextTest.assertNotNull((Object)ctx.toString());
        DefaultCamelContextTest.assertTrue((boolean)ctx.isAutoStartup());
    }

    public void testVersion() {
        DefaultCamelContext ctx = new DefaultCamelContext();
        ctx.disableJMX();
        DefaultCamelContextTest.assertNotNull((String)"Should have a version", (Object)ctx.getVersion());
    }

    public void testHasComponent() {
        DefaultCamelContext ctx = new DefaultCamelContext();
        ctx.disableJMX();
        DefaultCamelContextTest.assertNull((Object)ctx.hasComponent("log"));
        ctx.addComponent("log", (Component)new LogComponent());
        DefaultCamelContextTest.assertNotNull((Object)ctx.hasComponent("log"));
    }

    public void testGetComponent() {
        DefaultCamelContext ctx = new DefaultCamelContext();
        ctx.disableJMX();
        ctx.addComponent("log", (Component)new LogComponent());
        LogComponent log = (LogComponent)ctx.getComponent("log", LogComponent.class);
        DefaultCamelContextTest.assertNotNull((Object)log);
        try {
            ctx.addComponent("direct", (Component)new DirectComponent());
            ctx.getComponent("log", DirectComponent.class);
            DefaultCamelContextTest.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testHasEndpoint() throws Exception {
        DefaultCamelContext ctx = new DefaultCamelContext();
        ctx.disableJMX();
        ctx.getEndpoint("mock://foo");
        DefaultCamelContextTest.assertNotNull((Object)ctx.hasEndpoint("mock://foo"));
        DefaultCamelContextTest.assertNull((Object)ctx.hasEndpoint("mock://bar"));
        Map map = ctx.getEndpointMap();
        DefaultCamelContextTest.assertEquals((int)1, (int)map.size());
        try {
            ctx.hasEndpoint(null);
            DefaultCamelContextTest.fail((String)"Should have thrown exception");
        }
        catch (ResolveEndpointFailedException resolveEndpointFailedException) {
            // empty catch block
        }
    }

    public void testGetRouteById() throws Exception {
        DefaultCamelContext ctx = new DefaultCamelContext();
        ctx.disableJMX();
        Route route = ctx.getRoute("coolRoute");
        DefaultCamelContextTest.assertNull((Object)route);
        ctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routeId("coolRoute").to("mock:result");
            }
        });
        ctx.start();
        route = ctx.getRoute("coolRoute");
        DefaultCamelContextTest.assertNotNull((Object)route);
        DefaultCamelContextTest.assertEquals((String)"coolRoute", (String)route.getId());
        DefaultCamelContextTest.assertEquals((String)"direct://start", (String)route.getConsumer().getEndpoint().getEndpointUri());
        DefaultCamelContextTest.assertNull((Object)ctx.getRoute("unknown"));
        ctx.stop();
    }

    public void testSuspend() throws Exception {
        DefaultCamelContext ctx = new DefaultCamelContext();
        DefaultCamelContextTest.assertEquals((boolean)false, (boolean)ctx.isStarted());
        DefaultCamelContextTest.assertEquals((boolean)false, (boolean)ctx.isSuspended());
        ctx.start();
        DefaultCamelContextTest.assertEquals((boolean)true, (boolean)ctx.isStarted());
        DefaultCamelContextTest.assertEquals((boolean)false, (boolean)ctx.isSuspended());
        ctx.suspend();
        DefaultCamelContextTest.assertEquals((boolean)false, (boolean)ctx.isStarted());
        DefaultCamelContextTest.assertEquals((boolean)true, (boolean)ctx.isSuspended());
        ctx.suspend();
        DefaultCamelContextTest.assertEquals((boolean)false, (boolean)ctx.isStarted());
        DefaultCamelContextTest.assertEquals((boolean)true, (boolean)ctx.isSuspended());
        ctx.stop();
        DefaultCamelContextTest.assertEquals((boolean)false, (boolean)ctx.isStarted());
        DefaultCamelContextTest.assertEquals((boolean)false, (boolean)ctx.isSuspended());
    }

    public void testResume() throws Exception {
        DefaultCamelContext ctx = new DefaultCamelContext();
        DefaultCamelContextTest.assertEquals((boolean)false, (boolean)ctx.isStarted());
        DefaultCamelContextTest.assertEquals((boolean)false, (boolean)ctx.isSuspended());
        ctx.start();
        DefaultCamelContextTest.assertEquals((boolean)true, (boolean)ctx.isStarted());
        DefaultCamelContextTest.assertEquals((boolean)false, (boolean)ctx.isSuspended());
        ctx.resume();
        DefaultCamelContextTest.assertEquals((boolean)true, (boolean)ctx.isStarted());
        DefaultCamelContextTest.assertEquals((boolean)false, (boolean)ctx.isSuspended());
        ctx.resume();
        DefaultCamelContextTest.assertEquals((boolean)true, (boolean)ctx.isStarted());
        DefaultCamelContextTest.assertEquals((boolean)false, (boolean)ctx.isSuspended());
        ctx.stop();
        DefaultCamelContextTest.assertEquals((boolean)false, (boolean)ctx.isStarted());
        DefaultCamelContextTest.assertEquals((boolean)false, (boolean)ctx.isSuspended());
    }

    public void testSuspendResume() throws Exception {
        DefaultCamelContext ctx = new DefaultCamelContext();
        DefaultCamelContextTest.assertEquals((boolean)false, (boolean)ctx.isStarted());
        DefaultCamelContextTest.assertEquals((boolean)false, (boolean)ctx.isSuspended());
        ctx.start();
        DefaultCamelContextTest.assertEquals((boolean)true, (boolean)ctx.isStarted());
        DefaultCamelContextTest.assertEquals((boolean)false, (boolean)ctx.isSuspended());
        ctx.suspend();
        DefaultCamelContextTest.assertEquals((boolean)false, (boolean)ctx.isStarted());
        DefaultCamelContextTest.assertEquals((boolean)true, (boolean)ctx.isSuspended());
        ctx.resume();
        DefaultCamelContextTest.assertEquals((boolean)true, (boolean)ctx.isStarted());
        DefaultCamelContextTest.assertEquals((boolean)false, (boolean)ctx.isSuspended());
        ctx.stop();
        DefaultCamelContextTest.assertEquals((boolean)false, (boolean)ctx.isStarted());
        DefaultCamelContextTest.assertEquals((boolean)false, (boolean)ctx.isSuspended());
    }

    public void testAddServiceInjectCamelContext() throws Exception {
        MyService my = new MyService();
        DefaultCamelContext ctx = new DefaultCamelContext();
        ctx.addService((Object)my);
        DefaultCamelContextTest.assertEquals((Object)ctx, (Object)my.getCamelContext());
        DefaultCamelContextTest.assertEquals((String)"Started", (String)my.getStatus().name());
        ctx.stop();
        DefaultCamelContextTest.assertEquals((String)"Stopped", (String)my.getStatus().name());
    }

    public void testAddServiceType() throws Exception {
        MyService my = new MyService();
        DefaultCamelContext ctx = new DefaultCamelContext();
        DefaultCamelContextTest.assertNull((Object)ctx.hasService(MyService.class));
        ctx.addService((Object)my);
        DefaultCamelContextTest.assertSame((Object)((Object)my), (Object)ctx.hasService(MyService.class));
        ctx.stop();
        DefaultCamelContextTest.assertNull((Object)ctx.hasService(MyService.class));
    }

    private static class MyService
    extends ServiceSupport
    implements CamelContextAware {
        private CamelContext camelContext;

        private MyService() {
        }

        public CamelContext getCamelContext() {
            return this.camelContext;
        }

        public void setCamelContext(CamelContext camelContext) {
            this.camelContext = camelContext;
        }

        protected void doStart() throws Exception {
        }

        protected void doStop() throws Exception {
        }
    }
}

