/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;

public class DefaultCamelContextRestartTest
extends ContextTestSupport {
    public void testRestart() throws Exception {
        DefaultCamelContextRestartTest.assertTrue((boolean)this.context.getStatus().isStarted());
        DefaultCamelContextRestartTest.assertFalse((boolean)this.context.getStatus().isStopped());
        DefaultCamelContextRestartTest.assertEquals((int)1, (int)this.context.getRoutes().size());
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
        DefaultCamelContextRestartTest.assertFalse((boolean)this.context.getStatus().isStarted());
        DefaultCamelContextRestartTest.assertTrue((boolean)this.context.getStatus().isStopped());
        DefaultCamelContextRestartTest.assertEquals((int)0, (int)this.context.getRoutes().size());
        this.context.start();
        DefaultCamelContextRestartTest.assertTrue((boolean)this.context.getStatus().isStarted());
        DefaultCamelContextRestartTest.assertFalse((boolean)this.context.getStatus().isStopped());
        DefaultCamelContextRestartTest.assertEquals((int)1, (int)this.context.getRoutes().size());
        this.template = this.context.createProducerTemplate();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routeId("foo").to("mock:result");
            }
        };
    }
}

