/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.MessageHistory;
import org.apache.camel.NamedNode;
import org.apache.camel.impl.DefaultAsyncProcessorAwaitManager;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultMessageHistoryFactory;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.MessageHistoryFactory;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;

public class DefaultAsyncProcessorAwaitManagerTest {
    private static final MessageHistoryFactory MESSAGE_HISTORY_FACTORY = new DefaultMessageHistoryFactory();
    private DefaultAsyncProcessorAwaitManager defaultAsyncProcessorAwaitManager;
    private DefaultExchange exchange;
    private CountDownLatch latch;
    private Thread thread;

    @Test
    public void testNoMessageHistory() throws Exception {
        this.startAsyncProcess();
        AsyncProcessorAwaitManager.AwaitThread awaitThread = (AsyncProcessorAwaitManager.AwaitThread)this.defaultAsyncProcessorAwaitManager.browse().iterator().next();
        Assert.assertThat((Object)awaitThread.getRouteId(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)awaitThread.getNodeId(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        this.waitForEndOfAsyncProcess();
    }

    @Test
    public void testMessageHistoryWithEmptyList() throws Exception {
        this.startAsyncProcess();
        this.exchange.setProperty("CamelMessageHistory", new LinkedList());
        AsyncProcessorAwaitManager.AwaitThread awaitThread = (AsyncProcessorAwaitManager.AwaitThread)this.defaultAsyncProcessorAwaitManager.browse().iterator().next();
        Assert.assertThat((Object)awaitThread.getRouteId(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)awaitThread.getNodeId(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        this.waitForEndOfAsyncProcess();
    }

    @Test
    public void testMessageHistoryWithNullMessageHistory() throws Exception {
        this.startAsyncProcess();
        LinkedList<Object> messageHistories = new LinkedList<Object>();
        messageHistories.add(null);
        this.exchange.setProperty("CamelMessageHistory", messageHistories);
        AsyncProcessorAwaitManager.AwaitThread awaitThread = (AsyncProcessorAwaitManager.AwaitThread)this.defaultAsyncProcessorAwaitManager.browse().iterator().next();
        Assert.assertThat((Object)awaitThread.getRouteId(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)awaitThread.getNodeId(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        this.waitForEndOfAsyncProcess();
    }

    @Test
    public void testMessageHistoryWithNullElements() throws Exception {
        this.startAsyncProcess();
        LinkedList<MessageHistory> messageHistories = new LinkedList<MessageHistory>();
        messageHistories.add(MESSAGE_HISTORY_FACTORY.newMessageHistory(null, (NamedNode)new MockNamedNode().withId(null), null));
        this.exchange.setProperty("CamelMessageHistory", messageHistories);
        AsyncProcessorAwaitManager.AwaitThread awaitThread = (AsyncProcessorAwaitManager.AwaitThread)this.defaultAsyncProcessorAwaitManager.browse().iterator().next();
        Assert.assertThat((Object)awaitThread.getRouteId(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)awaitThread.getNodeId(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        this.waitForEndOfAsyncProcess();
    }

    @Test
    public void testMessageHistoryWithNotNullElements() throws Exception {
        this.startAsyncProcess();
        LinkedList<MessageHistory> messageHistories = new LinkedList<MessageHistory>();
        messageHistories.add(MESSAGE_HISTORY_FACTORY.newMessageHistory("routeId", (NamedNode)new MockNamedNode().withId("nodeId"), null));
        this.exchange.setProperty("CamelMessageHistory", messageHistories);
        AsyncProcessorAwaitManager.AwaitThread awaitThread = (AsyncProcessorAwaitManager.AwaitThread)this.defaultAsyncProcessorAwaitManager.browse().iterator().next();
        Assert.assertThat((Object)awaitThread.getRouteId(), (Matcher)Is.is((Object)"routeId"));
        Assert.assertThat((Object)awaitThread.getNodeId(), (Matcher)Is.is((Object)"nodeId"));
        this.waitForEndOfAsyncProcess();
    }

    private void waitForEndOfAsyncProcess() {
        this.latch.countDown();
        while (this.thread.isAlive()) {
        }
    }

    private void startAsyncProcess() throws InterruptedException {
        this.defaultAsyncProcessorAwaitManager = new DefaultAsyncProcessorAwaitManager();
        this.latch = new CountDownLatch(1);
        BackgroundAwait backgroundAwait = new BackgroundAwait();
        this.exchange = new DefaultExchange((CamelContext)new DefaultCamelContext());
        this.thread = new Thread(backgroundAwait);
        this.thread.start();
        Thread.sleep(100L);
    }

    private static class MockNamedNode
    implements NamedNode {
        private String id;

        private MockNamedNode() {
        }

        public String getId() {
            return this.id;
        }

        public String getShortName() {
            return this.getClass().getSimpleName();
        }

        public String getLabel() {
            return this.getClass().getName();
        }

        public String getDescriptionText() {
            return this.getClass().getCanonicalName();
        }

        public MockNamedNode withId(String id) {
            this.id = id;
            return this;
        }
    }

    private class BackgroundAwait
    implements Runnable {
        private BackgroundAwait() {
        }

        @Override
        public void run() {
            DefaultAsyncProcessorAwaitManagerTest.this.defaultAsyncProcessorAwaitManager.await((Exchange)DefaultAsyncProcessorAwaitManagerTest.this.exchange, DefaultAsyncProcessorAwaitManagerTest.this.latch);
        }
    }
}

