/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ServicePoolAware;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.spi.ServicePool;

public class CustomProducerServicePoolTest
extends ContextTestSupport {
    private static int counter;

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testCustomProducerServicePool() throws Exception {
        MyPool pool = new MyPool();
        pool.start();
        this.context.setProducerServicePool((ServicePool)pool);
        this.context.addEndpoint("my", (Endpoint)new MyEndpoint("my", (CamelContext)this.context));
        Endpoint endpoint = this.context.getEndpoint("my");
        CustomProducerServicePoolTest.assertNull((Object)pool.acquire(endpoint));
        CustomProducerServicePoolTest.assertEquals((int)0, (int)pool.size());
        MyProducer producer = new MyProducer(endpoint);
        producer = pool.addAndAcquire(endpoint, (Producer)producer);
        CustomProducerServicePoolTest.assertEquals((int)0, (int)pool.size());
        pool.release(endpoint, (Producer)producer);
        CustomProducerServicePoolTest.assertEquals((int)1, (int)pool.size());
        producer = pool.acquire(endpoint);
        CustomProducerServicePoolTest.assertNotNull((Object)((Object)producer));
        CustomProducerServicePoolTest.assertEquals((int)0, (int)pool.size());
        pool.release(endpoint, (Producer)producer);
        CustomProducerServicePoolTest.assertEquals((int)1, (int)pool.size());
        pool.purge();
        CustomProducerServicePoolTest.assertEquals((int)0, (int)pool.size());
        CustomProducerServicePoolTest.assertIsInstanceOf(MyPool.class, this.context.getProducerServicePool());
    }

    public void testCustomProducerServicePoolInRoute() throws Exception {
        this.context.addEndpoint("my", (Endpoint)new MyEndpoint("my", (CamelContext)this.context));
        MyPool pool = new MyPool();
        pool.start();
        this.context.setProducerServicePool((ServicePool)pool);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to(new String[]{"my", "mock:result"});
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        CustomProducerServicePoolTest.assertEquals((int)2, (int)counter);
        CustomProducerServicePoolTest.assertEquals((int)1, (int)pool.size());
        pool.purge();
        CustomProducerServicePoolTest.assertEquals((int)0, (int)pool.size());
    }

    private static class MyPool
    implements ServicePool<Endpoint, Producer> {
        private Producer producer;

        private MyPool() {
        }

        public void setCapacity(int capacity) {
        }

        public int getCapacity() {
            return 0;
        }

        public Producer addAndAcquire(Endpoint endpoint, Producer producer) {
            if (endpoint instanceof MyEndpoint) {
                return producer;
            }
            return null;
        }

        public Producer acquire(Endpoint endpoint) {
            if (endpoint instanceof MyEndpoint) {
                Producer answer = this.producer;
                this.producer = null;
                return answer;
            }
            return null;
        }

        public void release(Endpoint endpoint, Producer producer) {
            this.producer = producer;
        }

        public void start() throws Exception {
        }

        public int size() {
            return this.producer != null ? 1 : 0;
        }

        public void purge() {
            this.producer = null;
        }
    }

    private static final class MyProducer
    extends DefaultProducer
    implements ServicePoolAware {
        MyProducer(Endpoint endpoint) {
            super(endpoint);
        }

        public void process(Exchange exchange) throws Exception {
            counter++;
        }
    }

    private static final class MyEndpoint
    extends DefaultEndpoint {
        private MyEndpoint(String endpointUri, CamelContext camelContext) {
            this.setCamelContext(camelContext);
            this.setEndpointUri(endpointUri);
        }

        public Producer createProducer() throws Exception {
            return new MyProducer((Endpoint)this);
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            return null;
        }

        public boolean isSingleton() {
            return true;
        }

        protected String createEndpointUri() {
            return "my";
        }
    }
}

