/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Producer;
import org.apache.camel.ServicePoolAware;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.spi.ServicePool;

public class CamelContextSharedProducerServicePoolTest
extends ContextTestSupport {
    public void testSharedProducerServicePool() throws Exception {
        CamelContextSharedProducerServicePoolTest.assertEquals((int)100, (int)this.context.getProducerServicePool().getCapacity());
        this.context.getProducerServicePool().setCapacity(25);
        CamelContextSharedProducerServicePoolTest.assertEquals((int)25, (int)this.context.getProducerServicePool().getCapacity());
    }

    public void testSharedProducerServicePoolHitMax() throws Exception {
        CamelContextSharedProducerServicePoolTest.assertEquals((int)100, (int)this.context.getProducerServicePool().getCapacity());
        ServicePool pool = this.context.getProducerServicePool();
        pool.setCapacity(3);
        CamelContextSharedProducerServicePoolTest.assertEquals((int)3, (int)pool.getCapacity());
        Endpoint endpoint = this.context.getEndpoint("mock:foo");
        CamelContextSharedProducerServicePoolTest.assertNull((Object)pool.acquire((Object)endpoint));
        CamelContextSharedProducerServicePoolTest.assertEquals((int)0, (int)pool.size());
        MyProducer producer = new MyProducer(endpoint);
        producer = (Producer)pool.addAndAcquire((Object)endpoint, (Object)producer);
        CamelContextSharedProducerServicePoolTest.assertEquals((int)0, (int)pool.size());
        MyProducer producer2 = new MyProducer(endpoint);
        producer2 = (Producer)pool.addAndAcquire((Object)endpoint, (Object)producer2);
        CamelContextSharedProducerServicePoolTest.assertEquals((int)0, (int)pool.size());
        MyProducer producer3 = new MyProducer(endpoint);
        producer3 = (Producer)pool.addAndAcquire((Object)endpoint, (Object)producer3);
        CamelContextSharedProducerServicePoolTest.assertEquals((int)0, (int)pool.size());
        pool.release((Object)endpoint, (Object)producer);
        CamelContextSharedProducerServicePoolTest.assertEquals((int)1, (int)pool.size());
        pool.release((Object)endpoint, (Object)producer2);
        CamelContextSharedProducerServicePoolTest.assertEquals((int)2, (int)pool.size());
        pool.release((Object)endpoint, (Object)producer3);
        CamelContextSharedProducerServicePoolTest.assertEquals((int)3, (int)pool.size());
        MyProducer producer4 = new MyProducer(endpoint);
        try {
            producer4 = (Producer)pool.addAndAcquire((Object)endpoint, (Object)producer4);
            CamelContextSharedProducerServicePoolTest.fail((String)"Should throw an exception");
        }
        catch (IllegalStateException e) {
            CamelContextSharedProducerServicePoolTest.assertEquals((String)"Queue full", (String)e.getMessage());
        }
        CamelContextSharedProducerServicePoolTest.assertEquals((int)3, (int)pool.size());
    }

    private static class MyProducer
    extends DefaultProducer
    implements ServicePoolAware {
        private boolean start;
        private boolean stop;

        MyProducer(Endpoint endpoint) throws Exception {
            super(endpoint);
            this.start();
        }

        public void process(Exchange exchange) throws Exception {
        }

        protected void doStart() throws Exception {
            super.doStart();
            TestCase.assertEquals((String)"Should not be started twice", (boolean)false, (boolean)this.start);
            this.start = true;
        }

        protected void doStop() throws Exception {
            super.doStop();
            TestCase.assertEquals((String)"Should not be stopped twice", (boolean)false, (boolean)this.stop);
            this.stop = true;
        }
    }
}

