/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.net.URL;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.component.rest.DummyRestProcessorFactory;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.rest.RestDefinition;

public class CamelContextAddRestDefinitionsFromXmlTest
extends ContextTestSupport {
    protected JAXBContext jaxbContext;

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        jndi.bind("dummy-rest-api", (Object)new DummyRestProcessorFactory());
        return jndi;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.jaxbContext = this.context.getModelJAXBContextFactory().newJAXBContext();
    }

    protected Object parseUri(String uri) throws JAXBException {
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        URL resource = ((Object)((Object)this)).getClass().getResource(uri);
        CamelContextAddRestDefinitionsFromXmlTest.assertNotNull((String)("Cannot find resource on the classpath: " + uri), (Object)resource);
        Object value = unmarshaller.unmarshal(resource);
        return value;
    }

    protected RestDefinition loadRest(String uri) throws Exception {
        Object rest = this.parseUri(uri);
        return CamelContextAddRestDefinitionsFromXmlTest.assertIsInstanceOf(RestDefinition.class, rest);
    }

    public void testAddRestDefinitionsFromXml() throws Exception {
        RestDefinition rest = this.loadRest("rest1.xml");
        CamelContextAddRestDefinitionsFromXmlTest.assertNotNull((Object)rest);
        CamelContextAddRestDefinitionsFromXmlTest.assertEquals((String)"foo", (String)rest.getId());
        CamelContextAddRestDefinitionsFromXmlTest.assertEquals((int)0, (int)this.context.getRestDefinitions().size());
        this.context.getRestDefinitions().add(rest);
        CamelContextAddRestDefinitionsFromXmlTest.assertEquals((int)1, (int)this.context.getRestDefinitions().size());
        List routeDefinitions = rest.asRouteDefinition((CamelContext)this.context);
        for (RouteDefinition routeDefinition : routeDefinitions) {
            this.context.addRouteDefinition(routeDefinition);
        }
        CamelContextAddRestDefinitionsFromXmlTest.assertEquals((int)2, (int)this.context.getRoutes().size());
        CamelContextAddRestDefinitionsFromXmlTest.assertTrue((String)"Route should be started", (boolean)this.context.getRouteStatus("route1").isStarted());
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:get-say-hello-bar", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.restConfiguration().host("localhost").component("dummy-rest").apiContextPath("/api-docs");
            }
        };
    }
}

