/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.converter.NIOConverter;

public class NIOConverterTest
extends ContextTestSupport {
    public void testToByteArray() {
        ByteBuffer bb = ByteBuffer.wrap("Hello".getBytes());
        byte[] out = NIOConverter.toByteArray((ByteBuffer)bb);
        NIOConverterTest.assertNotNull((Object)out);
        NIOConverterTest.assertEquals((int)5, (int)out.length);
    }

    public void testToByteArrayBigBuffer() {
        ByteBuffer bb = ByteBuffer.allocate(100);
        bb.put("Hello".getBytes());
        bb.flip();
        byte[] out = NIOConverter.toByteArray((ByteBuffer)bb);
        NIOConverterTest.assertNotNull((Object)out);
        NIOConverterTest.assertEquals((int)5, (int)out.length);
    }

    public void testToString() throws Exception {
        ByteBuffer bb = ByteBuffer.wrap("Hello".getBytes());
        String out = NIOConverter.toString((ByteBuffer)bb, null);
        NIOConverterTest.assertNotNull((Object)out);
        NIOConverterTest.assertEquals((String)"Hello", (String)out);
    }

    public void testByteBufferToStringConversion() throws Exception {
        String str = "123456789";
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.put(str.getBytes());
        buffer.flip();
        String out = NIOConverter.toString((ByteBuffer)buffer, null);
        NIOConverterTest.assertEquals((String)str, (String)out);
    }

    public void testToByteBuffer() {
        ByteBuffer bb = NIOConverter.toByteBuffer((byte[])"Hello".getBytes());
        NIOConverterTest.assertNotNull((Object)bb);
    }

    public void testToByteBufferString() {
        ByteBuffer bb = NIOConverter.toByteBuffer((String)"Hello", null);
        NIOConverterTest.assertNotNull((Object)bb);
    }

    public void testToByteBufferFile() throws Exception {
        this.template.sendBodyAndHeader("file://target/nio", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        ByteBuffer bb = NIOConverter.toByteBuffer((File)new File("target/nio/hello.txt"));
        NIOConverterTest.assertNotNull((Object)bb);
        NIOConverterTest.assertEquals((String)"Hello World", (String)NIOConverter.toString((ByteBuffer)bb, null));
    }

    public void testToByteBufferShort() {
        ByteBuffer bb = NIOConverter.toByteBuffer((Short)Short.valueOf("2"));
        NIOConverterTest.assertNotNull((Object)bb);
        NIOConverterTest.assertEquals((int)2, (int)bb.getShort());
    }

    public void testToByteBufferInteger() {
        ByteBuffer bb = NIOConverter.toByteBuffer((Integer)Integer.valueOf("2"));
        NIOConverterTest.assertNotNull((Object)bb);
        NIOConverterTest.assertEquals((int)2, (int)bb.getInt());
    }

    public void testToByteBufferLong() {
        ByteBuffer bb = NIOConverter.toByteBuffer((Long)Long.valueOf("2"));
        NIOConverterTest.assertNotNull((Object)bb);
        NIOConverterTest.assertEquals((long)2L, (long)bb.getLong());
    }

    public void testToByteBufferDouble() {
        ByteBuffer bb = NIOConverter.toByteBuffer((Double)Double.valueOf("2"));
        NIOConverterTest.assertNotNull((Object)bb);
        NIOConverterTest.assertEquals((Object)2.0, (Object)bb.getDouble());
    }

    public void testToByteBufferFloat() {
        ByteBuffer bb = NIOConverter.toByteBuffer((Float)Float.valueOf("2"));
        NIOConverterTest.assertNotNull((Object)bb);
        NIOConverterTest.assertEquals((Object)Float.valueOf(2.0f), (Object)Float.valueOf(bb.getFloat()));
    }

    public void testToInputStream() throws Exception {
        ByteBuffer bb = ByteBuffer.wrap("Hello".getBytes());
        InputStream is = NIOConverter.toInputStream((ByteBuffer)bb);
        NIOConverterTest.assertNotNull((Object)is);
        NIOConverterTest.assertEquals((String)"Hello", (String)IOConverter.toString((InputStream)is, null));
    }
}

