/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vm;

import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.vm.AbstractVmTestSupport;
import org.apache.camel.model.RouteDefinition;

public class VmInOnlyChainedTest
extends AbstractVmTestSupport {
    public void testInOnlyVmChained() throws Exception {
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"start"});
        VmInOnlyChainedTest.resolveMandatoryEndpoint(this.context2, "mock:b", MockEndpoint.class).expectedBodiesReceived(new Object[]{"start-a"});
        this.getMockEndpoint("mock:c").expectedBodiesReceived(new Object[]{"start-a-b"});
        this.template.sendBody("vm:a", (Object)"start");
        this.assertMockEndpointsSatisfied();
        MockEndpoint.assertIsSatisfied((CamelContext)this.context2);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("vm:a").to("mock:a")).setBody((Expression)this.simple("${body}-a"))).to("vm:b");
                ((RouteDefinition)this.from("vm:c").to("mock:c")).setBody((Expression)this.simple("${body}-c"));
            }
        };
    }

    @Override
    protected RouteBuilder createRouteBuilderForSecondContext() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("vm:b").to("mock:b")).setBody((Expression)this.simple("${body}-b"))).to("vm:c");
            }
        };
    }
}

