/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.validator.ValidatorEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultClassResolver;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Registry;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorEndpointClearCachedSchemaTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatorEndpointClearCachedSchemaTest.class);
    private SimpleRegistry simpleReg;
    private CamelContext context;

    @Test
    public void testClearCachedSchema() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        new Sender().run();
        ExecutorService senderPool = Executors.newFixedThreadPool(5);
        ExecutorService executorClearCache = Executors.newFixedThreadPool(1);
        for (int i = 0; i < 5; ++i) {
            senderPool.execute(new Sender());
            if (i != 2) continue;
            executorClearCache.execute(new ClearCache());
        }
        senderPool.shutdown();
        executorClearCache.shutdown();
        senderPool.awaitTermination(2L, TimeUnit.SECONDS);
        List exchanges = mock.getExchanges();
        ValidatorEndpointClearCachedSchemaTest.assertNotNull((Object)exchanges);
        ValidatorEndpointClearCachedSchemaTest.assertTrue((String)"Less then expected exchanges", (exchanges.size() > 5 ? 1 : 0) != 0);
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        this.simpleReg = new SimpleRegistry();
        this.context = new DefaultCamelContext((Registry)this.simpleReg);
        this.context.setClassResolver((ClassResolver)new ClassResolverImpl());
        return this.context;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("validator:pd:somefile.xsd")).convertBodyTo(String.class)).to("log:after")).to("mock:result");
            }
        };
    }

    private void clearCachedSchema() throws Exception {
        Collection endpoints = this.context.getEndpoints();
        for (Endpoint endpoint : endpoints) {
            LOG.info("Endpoint URI: " + endpoint.getEndpointUri());
            if (!endpoint.getEndpointUri().startsWith("validator:")) continue;
            ValidatorEndpoint xsltEndpoint = (ValidatorEndpoint)endpoint;
            xsltEndpoint.clearCachedSchema();
            LOG.info("schema cache cleared");
        }
    }

    static class ClassResolverImpl
    extends DefaultClassResolver {
        private final String xsdtemplate1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xsd:schema targetNamespace=\"http://apache.camel.org/test\" xmlns=\"http://apache.camel.org/test\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">    <xsd:complexType name=\"TestMessage\">        <xsd:sequence>            <xsd:element name=\"Content\" type=\"xsd:string\" />        </xsd:sequence>        <xsd:attribute name=\"attr\" type=\"xsd:string\" default=\"xsd1\"/>    </xsd:complexType>    <xsd:element name=\"TestMessage\" type=\"TestMessage\" /></xsd:schema>";
        private final String xsdtemplate2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xsd:schema targetNamespace=\"http://apache.camel.org/test\" xmlns=\"http://apache.camel.org/test\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">    <xsd:complexType name=\"TestMessage\">        <xsd:sequence>            <xsd:element name=\"Content\" type=\"xsd:string\" />        </xsd:sequence>        <xsd:attribute name=\"attr\" type=\"xsd:string\" default=\"xsd1\"/>    </xsd:complexType>    <xsd:element name=\"TestMessage\" type=\"TestMessage\" /></xsd:schema>".replace("\"Content\"", "\"MessageContent\"");
        private byte[] xsd1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xsd:schema targetNamespace=\"http://apache.camel.org/test\" xmlns=\"http://apache.camel.org/test\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">    <xsd:complexType name=\"TestMessage\">        <xsd:sequence>            <xsd:element name=\"Content\" type=\"xsd:string\" />        </xsd:sequence>        <xsd:attribute name=\"attr\" type=\"xsd:string\" default=\"xsd1\"/>    </xsd:complexType>    <xsd:element name=\"TestMessage\" type=\"TestMessage\" /></xsd:schema>".getBytes(StandardCharsets.UTF_8);
        private byte[] xsd2 = this.xsdtemplate2.getBytes(StandardCharsets.UTF_8);
        private volatile short counter;

        ClassResolverImpl() {
        }

        public InputStream loadResourceAsStream(String uri) {
            if (uri.startsWith("pd:")) {
                byte[] xsd;
                if (this.counter == 0) {
                    xsd = this.xsd1;
                    LOG.info("resolved XSD1");
                } else {
                    xsd = this.xsd2;
                    LOG.info("resolved XSD2");
                }
                this.counter = (short)(this.counter + 1);
                return new ByteArrayInputStream(xsd);
            }
            return super.loadResourceAsStream(uri);
        }
    }

    private class ClearCache
    implements Runnable {
        private ClearCache() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(200L);
                ValidatorEndpointClearCachedSchemaTest.this.clearCachedSchema();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class Sender
    implements Runnable {
        private final String message = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><p:TestMessage xmlns:p=\"http://apache.camel.org/test\"><MessageContent>MessageContent</MessageContent></p:TestMessage>";
        private final byte[] messageBytes = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><p:TestMessage xmlns:p=\"http://apache.camel.org/test\"><MessageContent>MessageContent</MessageContent></p:TestMessage>".getBytes(StandardCharsets.UTF_8);

        private Sender() {
        }

        @Override
        public void run() {
            for (int j = 0; j < 5; ++j) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                ValidatorEndpointClearCachedSchemaTest.this.sendBody("direct:start", this.messageBytes);
            }
        }
    }
}

