/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingWithDelayTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(TracingWithDelayTest.class);

    public void testTracingWithDelay() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.getContext().setTracing(Boolean.valueOf(true));
                ((ExpressionNode)((ExpressionNode)((ExpressionNode)this.from("direct:start").delay(10L).to("mock:a")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        LOG.info("This is the processor being invoked between mock:a and mock:b");
                    }
                })).to("mock:b")).to("direct:c");
                ((RouteDefinition)this.from("direct:c").transform((Expression)this.constant("Bye World"))).to("mock:result");
            }
        };
    }
}

