/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToStartRouteException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class SedaConcurrentConsumersNPEIssueTest
extends ContextTestSupport {
    public void testSendToSeda() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        try {
            this.context.startRoute("first");
            SedaConcurrentConsumersNPEIssueTest.fail((String)"Should have thrown exception");
        }
        catch (FailedToStartRouteException e) {
            SedaConcurrentConsumersNPEIssueTest.assertEquals((String)"Failed to start route first because of Multiple consumers for the same endpoint is not allowed: Endpoint[seda://foo?concurrentConsumers=5]", (String)e.getMessage());
        }
    }

    public void testStartThird() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.context.startRoute("third");
        try {
            this.context.startRoute("first");
            SedaConcurrentConsumersNPEIssueTest.fail((String)"Should have thrown exception");
        }
        catch (FailedToStartRouteException e) {
            SedaConcurrentConsumersNPEIssueTest.assertEquals((String)"Failed to start route first because of Multiple consumers for the same endpoint is not allowed: Endpoint[seda://foo?concurrentConsumers=5]", (String)e.getMessage());
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("seda:foo?concurrentConsumers=5").routeId("first").noAutoStartup().to("mock:result");
                this.from("seda:foo?concurrentConsumers=5").routeId("second").to("mock:result");
                this.from("direct:foo").routeId("third").noAutoStartup().to("mock:result");
            }
        };
    }
}

