/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.RouteContext;

public class FromRestGetPolicyTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        return jndi;
    }

    public void testFromRestModel() throws Exception {
        FromRestGetPolicyTest.assertEquals((int)1, (int)this.context.getRoutes().size());
        FromRestGetPolicyTest.assertEquals((int)1, (int)this.context.getRestDefinitions().size());
        this.getMockEndpoint("mock:hello").expectedMessageCount(1);
        this.template.sendBody("seda:get-say-hello", null);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.restConfiguration().host("localhost");
                this.rest("/say/hello").get().route().policy((Policy)new MyDummyPolicy()).to("mock:hello");
            }
        };
    }

    private class MyDummyPolicy
    implements Policy {
        private MyDummyPolicy() {
        }

        public void beforeWrap(RouteContext routeContext, ProcessorDefinition<?> definition) {
        }

        public Processor wrap(RouteContext routeContext, Processor processor) {
            return processor;
        }
    }
}

