/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class FromRestGetOnExceptionTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        return jndi;
    }

    public void testFromRestModel() throws Exception {
        this.getMockEndpoint("mock:hello").expectedMessageCount(1);
        String out = (String)this.template.requestBody("seda:get-say-hello", (Object)"I was here", String.class);
        FromRestGetOnExceptionTest.assertEquals((String)"Handled the error", (String)out);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.restConfiguration().host("localhost");
                this.onException(IllegalArgumentException.class).handled(true).transform().constant((Object)"Handled the error");
                ((RouteDefinition)this.rest("/say/hello").get().route().to("mock:hello")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }
}

