/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.impl.JndiRegistry;

public class FromRestDuplicateTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        return jndi;
    }

    public void testDuplicateGet() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    this.restConfiguration().host("localhost");
                    this.rest("/users").get("{id}").to("log:foo").post().to("log:foo").get("").to("log:foo").get("{id}").to("log:foo");
                }
            });
            FromRestDuplicateTest.fail((String)"Should throw exception");
        }
        catch (IllegalArgumentException e) {
            FromRestDuplicateTest.assertEquals((String)"Duplicate verb detected in rest-dsl: get:{id}", (String)e.getMessage());
        }
    }

    public void testDuplicatePost() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    this.restConfiguration().host("localhost");
                    this.rest("/users").get("{id}").to("log:foo").post().to("log:foo").get("").to("log:foo").put().to("log:foo").post().to("log:foo");
                }
            });
            FromRestDuplicateTest.fail((String)"Should throw exception");
        }
        catch (IllegalArgumentException e) {
            FromRestDuplicateTest.assertEquals((String)"Duplicate verb detected in rest-dsl: post", (String)e.getMessage());
        }
    }
}

