/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.component.rest.FromRestGetTest;
import org.apache.camel.impl.FooBar;
import org.apache.camel.impl.JndiRegistry;

public class FromRestConfigurationTest
extends FromRestGetTest {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myDummy", (Object)new FooBar());
        return jndi;
    }

    @Override
    public void testFromRestModel() throws Exception {
        super.testFromRestModel();
        FromRestConfigurationTest.assertEquals((String)"dummy-rest", (String)this.context.getRestConfiguration().getComponent());
        FromRestConfigurationTest.assertEquals((String)"localhost", (String)this.context.getRestConfiguration().getHost());
        FromRestConfigurationTest.assertEquals((int)9090, (int)this.context.getRestConfiguration().getPort());
        FromRestConfigurationTest.assertEquals((Object)"bar", this.context.getRestConfiguration().getComponentProperties().get("foo"));
        FromRestConfigurationTest.assertEquals((Object)"stuff", this.context.getRestConfiguration().getComponentProperties().get("other"));
        FromRestConfigurationTest.assertEquals((Object)"200", this.context.getRestConfiguration().getEndpointProperties().get("size"));
        FromRestConfigurationTest.assertEquals((Object)"1000", this.context.getRestConfiguration().getConsumerProperties().get("pollTimeout"));
        FromRestConfigurationTest.assertEquals((Object)"#myDummy", this.context.getRestConfiguration().getConsumerProperties().get("dummy"));
        DummyRestConsumerFactory factory = (DummyRestConsumerFactory)this.context.getRegistry().lookupByName("dummy-rest");
        Object dummy = this.context.getRegistry().lookupByName("myDummy");
        FromRestConfigurationTest.assertSame((Object)dummy, (Object)factory.getDummy());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        final RouteBuilder lowerR = super.createRouteBuilder();
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.restConfiguration().component("dummy-rest").host("localhost").port(9090).componentProperty("foo", "bar").componentProperty("other", "stuff").endpointProperty("size", "200").consumerProperty("pollTimeout", "1000").consumerProperty("dummy", "#myDummy");
                this.includeRoutes((RoutesBuilder)lowerR);
            }
        };
    }
}

