/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.bean.MyDummyBean;
import org.apache.camel.component.bean.MyFooBean;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.impl.JndiRegistry;

public class PropertiesComponentRegistryTest
extends ContextTestSupport {
    private MyFooBean foo;
    private MyDummyBean bar;

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        this.foo = new MyFooBean();
        this.bar = new MyDummyBean();
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)this.foo);
        jndi.bind("bar", (Object)this.bar);
        return jndi;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        PropertiesComponent pc = new PropertiesComponent();
        pc.setLocation("classpath:org/apache/camel/component/properties/cheese.properties");
        context.addComponent("properties", (Component)pc);
        return context;
    }

    public void testPropertiesComponentRegistryPlain() throws Exception {
        this.context.start();
        PropertiesComponentRegistryTest.assertSame((Object)this.foo, (Object)this.context.getRegistry().lookupByName("foo"));
        PropertiesComponentRegistryTest.assertSame((Object)this.bar, (Object)this.context.getRegistry().lookupByName("bar"));
        PropertiesComponentRegistryTest.assertNull((Object)this.context.getRegistry().lookupByName("unknown"));
    }

    public void testPropertiesComponentRegistryLookupName() throws Exception {
        this.context.start();
        PropertiesComponentRegistryTest.assertSame((Object)this.foo, (Object)this.context.getRegistry().lookupByName("{{bean.foo}}"));
        PropertiesComponentRegistryTest.assertSame((Object)this.bar, (Object)this.context.getRegistry().lookupByName("{{bean.bar}}"));
        try {
            this.context.getRegistry().lookupByName("{{bean.unknown}}");
            PropertiesComponentRegistryTest.fail((String)"Should have thrown exception");
        }
        catch (RuntimeCamelException e) {
            IllegalArgumentException cause = PropertiesComponentRegistryTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            PropertiesComponentRegistryTest.assertEquals((String)"Property with key [bean.unknown] not found in properties from text: {{bean.unknown}}", (String)cause.getMessage());
        }
    }

    public void testPropertiesComponentRegistryLookupNameAndType() throws Exception {
        this.context.start();
        PropertiesComponentRegistryTest.assertSame((Object)this.foo, (Object)this.context.getRegistry().lookupByNameAndType("{{bean.foo}}", MyFooBean.class));
        PropertiesComponentRegistryTest.assertSame((Object)this.bar, (Object)this.context.getRegistry().lookupByNameAndType("{{bean.bar}}", MyDummyBean.class));
        try {
            this.context.getRegistry().lookupByNameAndType("{{bean.unknown}}", MyDummyBean.class);
            PropertiesComponentRegistryTest.fail((String)"Should have thrown exception");
        }
        catch (RuntimeCamelException e) {
            IllegalArgumentException cause = PropertiesComponentRegistryTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            PropertiesComponentRegistryTest.assertEquals((String)"Property with key [bean.unknown] not found in properties from text: {{bean.unknown}}", (String)cause.getMessage());
        }
    }
}

