/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.impl.JndiRegistry;

public class PropertiesComponentOnExceptionTest
extends ContextTestSupport {
    public void testPropertiesComponentOnException() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:dead");
        mock.expectedMessageCount(1);
        ((ValueBuilder)mock.message(0).header("CamelRedelivered")).isEqualTo((Object)true);
        ((ValueBuilder)mock.message(0).header("CamelRedeliveryCounter")).isEqualTo((Object)3);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            PropertiesComponentOnExceptionTest.fail((String)"Should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(Exception.class).redeliveryDelay("{{delay}}").maximumRedeliveries("{{max}}").to("mock:dead");
                this.from("direct:start").throwException((Exception)new IllegalAccessException("Damn"));
            }
        };
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        Properties cool = new Properties();
        cool.put("delay", "25");
        cool.put("max", "3");
        jndi.bind("myprop", (Object)cool);
        return jndi;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        PropertiesComponent pc = new PropertiesComponent();
        pc.setLocations(new String[]{"ref:myprop"});
        context.addComponent("properties", (Component)pc);
        return context;
    }
}

