/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.model.RouteDefinition;

public class PropertiesComponentInitialPropertiesTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testPropertiesComponentEndpoint() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("{{first}}")).to("mock:{{second}}")).to("{{cool.end}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:first").expectedMessageCount(1);
        this.getMockEndpoint("mock:second").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        PropertiesComponent pc = new PropertiesComponent();
        pc.setLocation("classpath:org/apache/camel/component/properties/myproperties.properties");
        context.addComponent("properties", (Component)pc);
        Properties initial = new Properties();
        initial.put("first", "mock:first");
        initial.put("second", "second");
        pc.setInitialProperties(initial);
        return context;
    }
}

