/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.model.ChoiceDefinition;

public class PropertiesComponentEIPChoiceSimpleTest
extends ContextTestSupport {
    public void testChoice() throws Exception {
        this.getMockEndpoint("mock:camel").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:other").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)this.from("direct:start").choice().when((Predicate)this.simple("${body} contains '${properties:cool.name}'")).to("mock:camel")).otherwise().to("mock:other");
            }
        };
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        PropertiesComponent pc = new PropertiesComponent();
        pc.setLocations(new String[]{"classpath:org/apache/camel/component/properties/myproperties.properties"});
        context.addComponent("properties", (Component)pc);
        return context;
    }
}

