/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class MockPredicateEqualityTest
extends ContextTestSupport {
    public void testByteArray() throws Exception {
        this.doTest(new byte[]{-34, -19, -66, -17});
    }

    public void testIntArray() throws Exception {
        this.doTest(new int[]{121, 122, 123});
    }

    public void testCharArray() throws Exception {
        this.doTest("forbar".toCharArray());
    }

    public void testStringArray() throws Exception {
        this.doTest(new String[]{"this", "is", "an", "array"});
    }

    public void doTest(Object anArray) throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:reverse");
        ((ValueBuilder)mock.message(0).body()).isEqualTo(anArray);
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", anArray);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").marshal().serialization().unmarshal().serialization().to("mock:reverse");
            }
        };
    }
}

