/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.language;

import java.net.URLEncoder;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class LanguageRouteConvertBodyTest
extends ContextTestSupport {
    public void testLanguage() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"123;Camel in Action"});
        this.template.sendBody("direct:start", (Object)new MyOrder(123, "Camel in Action"));
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                String script = URLEncoder.encode("${mandatoryBodyAs(String)}", "UTF-8");
                ((RouteDefinition)this.from("direct:start").to("language:simple:" + script)).to("mock:result");
            }
        };
    }

    private static final class MyOrder {
        private int id;
        private String name;

        private MyOrder(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String toString() {
            return this.id + ";" + this.name;
        }
    }
}

