/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.idempotent.MemoryIdempotentRepository;

public class FileIdempotentReadLockTest
extends ContextTestSupport {
    MemoryIdempotentRepository myRepo = new MemoryIdempotentRepository();

    @Override
    protected void setUp() throws Exception {
        FileIdempotentReadLockTest.deleteDirectory("target/changed/");
        FileIdempotentReadLockTest.createDirectory("target/changed/in");
        super.setUp();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myRepo", (Object)this.myRepo);
        return jndi;
    }

    public void testIdempotentReadLock() throws Exception {
        FileIdempotentReadLockTest.assertEquals((int)0, (int)this.myRepo.getCacheSize());
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(2).create();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        this.template.sendBodyAndHeader("file:target/changed/in", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader("file:target/changed/in", (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.assertMockEndpointsSatisfied();
        FileIdempotentReadLockTest.assertTrue((boolean)notify.matches(5L, TimeUnit.SECONDS));
        FileIdempotentReadLockTest.assertEquals((int)2, (int)this.myRepo.getCacheSize());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file:target/changed/in?readLock=idempotent&idempotentRepository=#myRepo").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        int size = FileIdempotentReadLockTest.this.myRepo.getCacheSize();
                        TestCase.assertTrue((size == 1 || size == 2 ? 1 : 0) != 0);
                    }
                })).to("mock:result");
            }
        };
    }
}

